/*
 * Decompiled with CFR 0.152.
 */
package org.febit.wit;

import java.io.OutputStream;
import java.io.Writer;
import java.util.Map;
import org.febit.wit.Context;
import org.febit.wit.Engine;
import org.febit.wit.InternalContext;
import org.febit.wit.Vars;
import org.febit.wit.core.Parser;
import org.febit.wit.core.ast.TemplateAST;
import org.febit.wit.debug.BreakPointListener;
import org.febit.wit.exceptions.ScriptRuntimeException;
import org.febit.wit.exceptions.TemplateException;
import org.febit.wit.io.Out;
import org.febit.wit.io.impl.DiscardOut;
import org.febit.wit.io.impl.OutputStreamOut;
import org.febit.wit.io.impl.WriterOut;
import org.febit.wit.loaders.Resource;
import org.febit.wit.util.InternedEncoding;

public class Template {
    private final Engine engine;
    private final String name;
    private final Resource resource;
    private TemplateAST ast;
    private long lastModified;

    Template(Engine engine, String string, Resource resource) {
        this.engine = engine;
        this.name = string;
        this.resource = resource;
    }

    public void reload() {
        this.parse(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TemplateAST parse(boolean bl) {
        TemplateAST templateAST = this.ast;
        Template template = this;
        synchronized (template) {
            if (bl || templateAST == null || this.resource.isModified()) {
                this.ast = templateAST = Parser.parse(this);
                this.lastModified = System.currentTimeMillis();
            }
        }
        return templateAST;
    }

    public Context merge(OutputStream outputStream) {
        return this.merge(Vars.EMPTY, new OutputStreamOut(outputStream, this.engine));
    }

    public Context merge(OutputStream outputStream, String string) {
        return this.merge(Vars.EMPTY, new OutputStreamOut(outputStream, InternedEncoding.intern(string), this.engine));
    }

    public Context merge(Writer writer) {
        return this.merge(Vars.EMPTY, new WriterOut(writer, this.engine));
    }

    public Context merge(Map<String, Object> map, OutputStream outputStream) {
        return this.merge(Vars.of(map), new OutputStreamOut(outputStream, this.engine));
    }

    public Context merge(Map<String, Object> map, OutputStream outputStream, String string) {
        return this.merge(Vars.of(map), new OutputStreamOut(outputStream, InternedEncoding.intern(string), this.engine));
    }

    public Context merge(Map<String, Object> map, Writer writer) {
        return this.merge(Vars.of(map), new WriterOut(writer, this.engine));
    }

    public Context merge(Vars vars, OutputStream outputStream) {
        return this.merge(vars, new OutputStreamOut(outputStream, this.engine));
    }

    public Context merge(Vars vars, OutputStream outputStream, String string) {
        return this.merge(vars, new OutputStreamOut(outputStream, InternedEncoding.intern(string), this.engine));
    }

    public Context merge(Vars vars, Writer writer) {
        return this.merge(vars, new WriterOut(writer, this.engine));
    }

    public Context merge(Out out) {
        return this.merge(Vars.EMPTY, out);
    }

    public Context merge() {
        return this.merge(Vars.EMPTY);
    }

    public Context merge(Map<String, Object> map) {
        return this.merge(Vars.of(map));
    }

    public Context merge(Vars vars) {
        return this.merge(vars, DiscardOut.INSTANCE);
    }

    public Context merge(Vars vars, Out out) {
        try {
            TemplateAST templateAST = this.ast;
            return (templateAST == null || this.resource.isModified() ? this.parse(false) : templateAST).execute(this, out, vars);
        }
        catch (Exception exception) {
            throw this.completeException(exception);
        }
    }

    public Context mergeToContext(InternalContext internalContext, Vars vars) {
        try {
            TemplateAST templateAST = this.ast;
            return (templateAST == null || this.resource.isModified() ? this.parse(false) : templateAST).execute(this, internalContext, vars);
        }
        catch (Exception exception) {
            throw this.completeException(exception);
        }
    }

    public Context debug(Vars vars, Out out, BreakPointListener breakPointListener) {
        try {
            return Parser.parse(this, breakPointListener).execute(this, out, vars);
        }
        catch (Exception exception) {
            throw this.completeException(exception);
        }
    }

    public Context debug(Vars vars, BreakPointListener breakPointListener) {
        return this.debug(vars, DiscardOut.INSTANCE, breakPointListener);
    }

    public Context debug(Out out, BreakPointListener breakPointListener) {
        return this.debug(Vars.EMPTY, out, breakPointListener);
    }

    public Context debug(BreakPointListener breakPointListener) {
        return this.debug(Vars.EMPTY, DiscardOut.INSTANCE, breakPointListener);
    }

    public void reset() {
        this.ast = null;
        this.lastModified = 0L;
    }

    public long getLastModified() {
        return this.lastModified;
    }

    public Engine getEngine() {
        return this.engine;
    }

    public String getName() {
        return this.name;
    }

    public Resource getResource() {
        return this.resource;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !(object instanceof Template)) {
            return false;
        }
        Template template = (Template)object;
        return this.engine == template.engine && this.name.equals(template.name);
    }

    private TemplateException completeException(Exception exception) {
        return (exception instanceof TemplateException ? (TemplateException)exception : new ScriptRuntimeException(exception)).setTemplate(this);
    }
}

