/*
 * Decompiled with CFR 0.152.
 */
package org.febit.wit;

import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import org.febit.wit.Context;
import org.febit.wit.Engine;
import org.febit.wit.Function;
import org.febit.wit.Template;
import org.febit.wit.Vars;
import org.febit.wit.core.VariantIndexer;
import org.febit.wit.exceptions.NotFunctionException;
import org.febit.wit.exceptions.ScriptRuntimeException;
import org.febit.wit.io.Out;
import org.febit.wit.lang.MethodDeclare;
import org.febit.wit.resolvers.GetResolver;
import org.febit.wit.resolvers.OutResolver;
import org.febit.wit.resolvers.ResolverManager;
import org.febit.wit.resolvers.SetResolver;
import org.febit.wit.util.ClassMap;
import org.febit.wit.util.InternedEncoding;

public final class InternalContext
implements Context {
    private final Template template;
    private final Vars rootParams;
    public final Object[] vars;
    private final Object[][] parentScopes;
    private final VariantIndexer[] indexers;
    public final boolean isByteStream;
    public final InternedEncoding encoding;
    public int indexer;
    private Out out;
    private Object returned;
    private int label;
    private int loopType;
    private Map<Object, Object> locals;
    private InternalContext localContext;
    private final ResolverManager resolverManager;
    private final ClassMap<OutResolver> outters;
    private final ClassMap<GetResolver> getters;
    private final ClassMap<SetResolver> setters;

    public InternalContext(Template template, Out out, Vars vars, VariantIndexer[] variantIndexerArray, int n, Object[][] objectArray) {
        ResolverManager resolverManager;
        this.template = template;
        this.rootParams = vars;
        this.out = out;
        this.encoding = out.getEncoding();
        this.isByteStream = out.isByteStream();
        this.resolverManager = resolverManager = template.getEngine().getResolverManager();
        this.outters = resolverManager.outters;
        this.getters = resolverManager.getters;
        this.setters = resolverManager.setters;
        this.indexers = variantIndexerArray;
        this.indexer = 0;
        this.vars = new Object[n];
        this.parentScopes = objectArray;
        vars.exportTo(this::set);
    }

    public InternalContext createSubContext(VariantIndexer[] variantIndexerArray, InternalContext internalContext, int n) {
        Object[][] objectArray;
        Object[][] objectArray2 = this.parentScopes;
        if (objectArray2 == null) {
            objectArray = new Object[][]{this.vars};
        } else {
            objectArray = new Object[objectArray2.length + 1][];
            objectArray[0] = this.vars;
            System.arraycopy(objectArray2, 0, objectArray, 1, objectArray2.length);
        }
        InternalContext internalContext2 = new InternalContext(this.template, internalContext.out, Vars.EMPTY, variantIndexerArray, n, objectArray);
        internalContext2.localContext = internalContext;
        return internalContext2;
    }

    public InternalContext createPeerContext(Template template, VariantIndexer[] variantIndexerArray, int n) {
        InternalContext internalContext = new InternalContext(template, this.out, Vars.EMPTY, variantIndexerArray, n, null);
        internalContext.localContext = this;
        return internalContext;
    }

    public boolean matchLabel(int n) {
        return this.label == 0 || this.label == n;
    }

    public void breakLoop(int n) {
        this.label = n;
        this.loopType = 1;
    }

    public void continueLoop(int n) {
        this.label = n;
        this.loopType = 2;
    }

    public void returnLoop(Object object) {
        this.returned = object;
        this.label = 0;
        this.loopType = 3;
    }

    public void resetLoop() {
        this.returned = null;
        this.label = 0;
        this.loopType = 0;
    }

    public void resetBreakLoopIfMatch(int n) {
        if (this.loopType == 1 && (this.label == 0 || this.label == n)) {
            this.resetLoop();
        }
    }

    public Object resetReturnLoop() {
        Object object = this.loopType == 3 ? this.returned : VOID;
        this.resetLoop();
        return object;
    }

    public int getLoopType() {
        return this.loopType;
    }

    public boolean noLoop() {
        return this.loopType == 0;
    }

    public <T> Object getBeanProperty(T t, Object object) {
        GetResolver getResolver;
        if (t != null && (getResolver = this.getters.unsafeGet(t.getClass())) != null) {
            return getResolver.get(t, object);
        }
        return this.resolverManager.get(t, object);
    }

    public <T> void setBeanProperty(T t, Object object, Object object2) {
        SetResolver setResolver;
        if (t != null && (setResolver = this.setters.unsafeGet(t.getClass())) != null) {
            setResolver.set(t, object, object2);
            return;
        }
        this.resolverManager.set(t, object, object2);
    }

    public void outNotNull(byte[] byArray) {
        this.out.write(byArray);
    }

    public void outNotNull(char[] cArray) {
        this.out.write(cArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object temporaryOut(Out out, java.util.function.Function<InternalContext, Object> function) {
        Out out2 = this.out;
        this.out = out;
        try {
            Object object = function.apply(this);
            return object;
        }
        finally {
            this.out = out2;
        }
    }

    public <T> void write(T t) {
        if (t == null) {
            return;
        }
        Class<?> clazz = t.getClass();
        if (clazz == String.class) {
            this.out.write((String)t);
            return;
        }
        OutResolver outResolver = this.outters.unsafeGet(clazz);
        if (outResolver != null) {
            outResolver.render(this.out, t);
            return;
        }
        this.resolverManager.resolveOutResolver(clazz).render(this.out, t);
    }

    @Override
    public Object getLocal(Object object) {
        if (this.localContext != null) {
            return this.localContext.getLocal(object);
        }
        Map<Object, Object> map = this.locals;
        return map != null ? map.get(object) : null;
    }

    @Override
    public void setLocal(Object object, Object object2) {
        if (this.localContext != null) {
            this.localContext.setLocal(object, object2);
            return;
        }
        if (this.locals == null) {
            this.locals = new HashMap<Object, Object>();
        }
        this.locals.put(object, object2);
    }

    @Override
    public void set(String string, Object object) {
        int n = this.indexers[this.indexer].getIndex(string);
        if (n >= 0) {
            this.vars[n] = object;
        }
    }

    @Override
    public Object get(String string) throws ScriptRuntimeException {
        return this.get(string, true);
    }

    @Override
    public Object get(String string, boolean bl) throws ScriptRuntimeException {
        int n = this.getCurrentIndexer().getIndex(string);
        if (n >= 0) {
            return this.vars[n];
        }
        if (bl) {
            throw new ScriptRuntimeException("Not found variant named:".concat(string));
        }
        return null;
    }

    public Object getParentScopeValue(int n, int n2) {
        return this.parentScopes[n][n2];
    }

    public void setParentScopeValue(int n, int n2, Object object) {
        this.parentScopes[n][n2] = object;
    }

    public VariantIndexer getCurrentIndexer() {
        return this.indexers[this.indexer];
    }

    @Override
    public void forEachVar(BiConsumer<? super String, Object> biConsumer) {
        Object[] objectArray = this.vars;
        this.getCurrentIndexer().forEach((string, n) -> biConsumer.accept((String)string, objectArray[n]));
    }

    @Override
    public void exportTo(Map<? super String, Object> map) {
        this.forEachVar(map::put);
    }

    @Override
    public Function exportFunction(String string) throws NotFunctionException {
        Object object = this.get(string, false);
        if (!(object instanceof MethodDeclare)) {
            throw new NotFunctionException(object);
        }
        return new Function(this.template, (MethodDeclare)object, this.encoding, this.isByteStream);
    }

    public Engine getEngine() {
        return this.template.getEngine();
    }

    public Template getTemplate() {
        return this.template;
    }

    public Vars getRootParams() {
        return this.rootParams;
    }
}

