/*
 * Decompiled with CFR 0.152.
 */
package org.febit.wit;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.febit.wit.Template;
import org.febit.wit.Vars;
import org.febit.wit.core.NativeFactory;
import org.febit.wit.exceptions.IllegalConfigException;
import org.febit.wit.exceptions.ResourceNotFoundException;
import org.febit.wit.global.GlobalManager;
import org.febit.wit.io.charset.CoderFactory;
import org.febit.wit.loaders.Loader;
import org.febit.wit.loggers.Logger;
import org.febit.wit.resolvers.ResolverManager;
import org.febit.wit.util.InternedEncoding;
import org.febit.wit.util.Petite;
import org.febit.wit.util.Props;
import org.febit.wit.util.PropsUtil;
import org.febit.wit.util.StringUtil;

public class Engine {
    public static final String DEFAULT_WIM = "/wit-default.wim";
    protected final ConcurrentMap<String, Template> cachedTemplates = new ConcurrentHashMap<String, Template>();
    protected boolean looseVar;
    protected boolean shareRootData = true;
    protected boolean trimCodeBlockBlankLine = true;
    protected boolean looseSemicolon = true;
    protected InternedEncoding encoding;
    protected String inits;
    protected String vars;
    protected Petite petite;
    protected Logger logger;
    protected Loader loader;
    protected GlobalManager globalManager;
    protected CoderFactory coderFactory;
    protected NativeFactory nativeFactory;
    protected ResolverManager resolverManager;

    protected void executeInits() throws ResourceNotFoundException {
        if (this.inits == null) {
            return;
        }
        Vars vars = Vars.of(new String[]{"GLOBAL", "CONST"}, new Object[]{this.globalManager.getGlobalBag(), this.globalManager.getConstBag()});
        for (String string : StringUtil.toArray(this.inits)) {
            this.logger.info("Merge init template: {}", string);
            this.getTemplate(string).merge(vars);
        }
    }

    public Template getTemplate(String string, String string2) throws ResourceNotFoundException {
        return this.getTemplate(this.loader.concat(string, string2));
    }

    public Template getTemplate(String string) throws ResourceNotFoundException {
        Template template = (Template)this.cachedTemplates.get(string);
        if (template != null) {
            return template;
        }
        return this.createTemplateIfAbsent(string);
    }

    public boolean exists(String string) {
        Loader loader = this.loader;
        String string2 = loader.normalize(string);
        if (string2 == null) {
            return false;
        }
        return loader.get(string2).exists();
    }

    protected Template createTemplateIfAbsent(String string) throws ResourceNotFoundException {
        Template template;
        Loader loader = this.loader;
        String string2 = loader.normalize(string);
        if (string2 == null) {
            throw new ResourceNotFoundException("Illegal template path: ".concat(string));
        }
        Template template2 = (Template)this.cachedTemplates.get(string2);
        if (template2 != null) {
            return template2;
        }
        template2 = new Template(this, string2, loader.get(string2));
        if (loader.isEnableCache(string2) && (template = this.cachedTemplates.putIfAbsent(string2, template2)) != null) {
            template2 = template;
        }
        return template2;
    }

    public <T> T get(Class<T> clazz) {
        return this.petite.get(clazz);
    }

    public Object get(String string) {
        return this.petite.get(string);
    }

    public Object getConfig(String string) {
        return this.petite.getConfig(string);
    }

    public void addComponent(Object object) {
        this.petite.addComponent(object);
    }

    public void inject(String string, Object object) {
        this.petite.inject(string, object);
    }

    public CoderFactory getCoderFactory() {
        return this.coderFactory;
    }

    public boolean isLooseVar() {
        return this.looseVar;
    }

    public boolean isTrimCodeBlockBlankLine() {
        return this.trimCodeBlockBlankLine;
    }

    public boolean isLooseSemicolon() {
        return this.looseSemicolon;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public GlobalManager getGlobalManager() {
        return this.globalManager;
    }

    public NativeFactory getNativeFactory() {
        return this.nativeFactory;
    }

    public boolean isShareRootData() {
        return this.shareRootData;
    }

    public ResolverManager getResolverManager() {
        return this.resolverManager;
    }

    public InternedEncoding getEncoding() {
        return this.encoding;
    }

    public String[] getVars() {
        return StringUtil.toArray(this.vars);
    }

    public static Props createConfigProps(String string) {
        return PropsUtil.loadFromClasspath(new Props(), DEFAULT_WIM, string);
    }

    public static Engine create() {
        return Engine.create("", null);
    }

    public static Engine create(String string) {
        return Engine.create(string, null);
    }

    public static Engine create(String string, Map<String, Object> map) {
        return Engine.create(Engine.createConfigProps(string), map);
    }

    public static Engine create(Props props, Map<String, Object> map) {
        Petite petite = new Petite();
        petite.config(props, map);
        petite.initComponents();
        Engine engine = petite.get(Engine.class);
        engine.getLogger().info("Loaded props: {}", props.getModulesString());
        try {
            engine.executeInits();
        }
        catch (ResourceNotFoundException resourceNotFoundException) {
            throw new IllegalConfigException("engine.inits", resourceNotFoundException);
        }
        return engine;
    }
}

