/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shiro.config;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.beanutils.BeanIntrospector;
import org.apache.commons.beanutils.BeanUtilsBean;
import org.apache.commons.beanutils.SuppressPropertiesBeanIntrospector;
import org.apache.shiro.codec.Base64;
import org.apache.shiro.codec.Hex;
import org.apache.shiro.config.CommonsInterpolator;
import org.apache.shiro.config.ConfigurationException;
import org.apache.shiro.config.DefaultInterpolator;
import org.apache.shiro.config.Interpolator;
import org.apache.shiro.config.UnresolveableReferenceException;
import org.apache.shiro.config.event.BeanEvent;
import org.apache.shiro.config.event.ConfiguredBeanEvent;
import org.apache.shiro.config.event.DestroyedBeanEvent;
import org.apache.shiro.config.event.InitializedBeanEvent;
import org.apache.shiro.config.event.InstantiatedBeanEvent;
import org.apache.shiro.event.EventBus;
import org.apache.shiro.event.EventBusAware;
import org.apache.shiro.event.Subscribe;
import org.apache.shiro.event.support.DefaultEventBus;
import org.apache.shiro.util.Assert;
import org.apache.shiro.util.ByteSource;
import org.apache.shiro.util.ClassUtils;
import org.apache.shiro.util.Factory;
import org.apache.shiro.util.LifecycleUtils;
import org.apache.shiro.util.Nameable;
import org.apache.shiro.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReflectionBuilder {
    private static final Logger log = LoggerFactory.getLogger(ReflectionBuilder.class);
    private static final String OBJECT_REFERENCE_BEGIN_TOKEN = "$";
    private static final String ESCAPED_OBJECT_REFERENCE_BEGIN_TOKEN = "\\$";
    private static final String GLOBAL_PROPERTY_PREFIX = "shiro";
    private static final char MAP_KEY_VALUE_DELIMITER = ':';
    private static final String HEX_BEGIN_TOKEN = "0x";
    private static final String NULL_VALUE_TOKEN = "null";
    private static final String EMPTY_STRING_VALUE_TOKEN = "\"\"";
    private static final char STRING_VALUE_DELIMETER = '\"';
    private static final char MAP_PROPERTY_BEGIN_TOKEN = '[';
    private static final char MAP_PROPERTY_END_TOKEN = ']';
    private static final String EVENT_BUS_NAME = "eventBus";
    private final Map<String, Object> objects;
    private Interpolator interpolator;
    private EventBus eventBus;
    private final Map<String, Object> registeredEventSubscribers;
    private final BeanUtilsBean beanUtilsBean = new BeanUtilsBean();

    private Map<String, Object> createDefaultObjectMap() {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put(EVENT_BUS_NAME, new DefaultEventBus());
        return map;
    }

    public ReflectionBuilder() {
        this(null);
    }

    public ReflectionBuilder(Map<String, ?> defaults) {
        this.beanUtilsBean.getPropertyUtils().addBeanIntrospector((BeanIntrospector)SuppressPropertiesBeanIntrospector.SUPPRESS_CLASS);
        this.interpolator = this.createInterpolator();
        this.objects = this.createDefaultObjectMap();
        this.registeredEventSubscribers = new LinkedHashMap<String, Object>();
        this.apply(defaults);
    }

    private void apply(Map<String, ?> objects) {
        if (!ReflectionBuilder.isEmpty(objects)) {
            this.objects.putAll(objects);
        }
        EventBus found = this.findEventBus(this.objects);
        Assert.notNull(found, "An " + EventBus.class.getName() + " instance must be present in the object defaults");
        this.enableEvents(found);
    }

    public Map<String, ?> getObjects() {
        return this.objects;
    }

    public void setObjects(Map<String, ?> objects) {
        this.objects.clear();
        this.objects.putAll(this.createDefaultObjectMap());
        this.apply(objects);
    }

    private void enableEvents(EventBus eventBus) {
        Assert.notNull(eventBus, "EventBus argument cannot be null.");
        for (Object object : this.registeredEventSubscribers.values()) {
            this.eventBus.unregister(object);
        }
        this.registeredEventSubscribers.clear();
        this.eventBus = eventBus;
        for (Map.Entry entry : this.objects.entrySet()) {
            this.enableEventsIfNecessary(entry.getValue(), (String)entry.getKey());
        }
    }

    private void enableEventsIfNecessary(Object bean, String name) {
        boolean applied = this.applyEventBusIfNecessary(bean);
        if (!applied && this.isEventSubscriber(bean, name)) {
            this.eventBus.register(bean);
            this.registeredEventSubscribers.put(name, bean);
        }
    }

    private boolean isEventSubscriber(Object bean, String name) {
        List<Method> annotatedMethods = ClassUtils.getAnnotatedMethods(bean.getClass(), Subscribe.class);
        return !ReflectionBuilder.isEmpty(annotatedMethods);
    }

    protected EventBus findEventBus(Map<String, ?> objects) {
        if (ReflectionBuilder.isEmpty(objects)) {
            return null;
        }
        Object value = objects.get(EVENT_BUS_NAME);
        if (value != null && value instanceof EventBus) {
            return (EventBus)value;
        }
        for (Object v : objects.values()) {
            if (!(v instanceof EventBus)) continue;
            return (EventBus)v;
        }
        return null;
    }

    private boolean applyEventBusIfNecessary(Object value) {
        if (value instanceof EventBusAware) {
            ((EventBusAware)value).setEventBus(this.eventBus);
            return true;
        }
        return false;
    }

    public Object getBean(String id) {
        return this.objects.get(id);
    }

    public <T> T getBean(String id, Class<T> requiredType) {
        if (requiredType == null) {
            throw new NullPointerException("requiredType argument cannot be null.");
        }
        Object bean = this.getBean(id);
        if (bean == null) {
            return null;
        }
        Assert.state(requiredType.isAssignableFrom(bean.getClass()), "Bean with id [" + id + "] is not of the required type [" + requiredType.getName() + "].");
        return (T)bean;
    }

    private String parseBeanId(String lhs) {
        Assert.notNull(lhs);
        if (lhs.indexOf(46) < 0) {
            return lhs;
        }
        String classSuffix = ".class";
        int index = lhs.indexOf(classSuffix);
        if (index >= 0) {
            return lhs.substring(0, index);
        }
        return null;
    }

    public Map<String, ?> buildObjects(Map<String, String> kvPairs) {
        if (kvPairs != null && !kvPairs.isEmpty()) {
            BeanConfigurationProcessor processor = new BeanConfigurationProcessor();
            for (Map.Entry<String, String> entry : kvPairs.entrySet()) {
                String lhs = entry.getKey();
                String rhs = this.interpolator.interpolate(entry.getValue());
                String beanId = this.parseBeanId(lhs);
                if (beanId != null) {
                    processor.add(new InstantiationStatement(beanId, rhs));
                    continue;
                }
                processor.add(new AssignmentStatement(lhs, rhs));
            }
            processor.execute();
        }
        LifecycleUtils.init(this.objects.values());
        return this.objects;
    }

    public void destroy() {
        Map<String, Object> immutableObjects = Collections.unmodifiableMap(this.objects);
        ArrayList<Map.Entry<String, Object>> entries = new ArrayList<Map.Entry<String, Object>>(this.objects.entrySet());
        Collections.reverse(entries);
        for (Map.Entry entry : entries) {
            String id = (String)entry.getKey();
            Object bean = entry.getValue();
            if (bean == this.eventBus) continue;
            LifecycleUtils.destroy(bean);
            DestroyedBeanEvent event = new DestroyedBeanEvent(id, bean, immutableObjects);
            this.eventBus.publish(event);
            this.eventBus.unregister(bean);
        }
        LifecycleUtils.destroy(this.eventBus);
    }

    protected void createNewInstance(Map<String, Object> objects, String name, String value) {
        Object instance;
        Object currentInstance = objects.get(name);
        if (currentInstance != null) {
            log.info("An instance with name '{}' already exists.  Redefining this object as a new instance of type {}", (Object)name, (Object)value);
        }
        try {
            instance = ClassUtils.newInstance(value);
            if (instance instanceof Nameable) {
                ((Nameable)instance).setName(name);
            }
        }
        catch (Exception e) {
            String msg = "Unable to instantiate class [" + value + "] for object named '" + name + "'.  " + "Please ensure you've specified the fully qualified class name correctly.";
            throw new ConfigurationException(msg, e);
        }
        objects.put(name, instance);
    }

    protected void applyProperty(String key, String value, Map objects) {
        int index = key.indexOf(46);
        if (index >= 0) {
            String name = key.substring(0, index);
            String property = key.substring(index + 1, key.length());
            if (GLOBAL_PROPERTY_PREFIX.equalsIgnoreCase(name)) {
                this.applyGlobalProperty(objects, property, value);
            } else {
                this.applySingleProperty(objects, name, property, value);
            }
        } else {
            throw new IllegalArgumentException("All property keys must contain a '.' character. (e.g. myBean.property = value)  These should already be separated out by buildObjects().");
        }
    }

    protected void applyGlobalProperty(Map objects, String property, String value) {
        for (Object instance : objects.values()) {
            try {
                PropertyDescriptor pd = this.beanUtilsBean.getPropertyUtils().getPropertyDescriptor(instance, property);
                if (pd == null) continue;
                this.applyProperty(instance, property, value);
            }
            catch (Exception e) {
                String msg = "Error retrieving property descriptor for instance of type [" + instance.getClass().getName() + "] " + "while setting property [" + property + "]";
                throw new ConfigurationException(msg, e);
            }
        }
    }

    protected void applySingleProperty(Map objects, String name, String property, String value) {
        Object instance = objects.get(name);
        if (property.equals("class")) {
            throw new IllegalArgumentException("Property keys should not contain 'class' properties since these should already be separated out by buildObjects().");
        }
        if (instance == null) {
            String msg = "Configuration error.  Specified object [" + name + "] with property [" + property + "] without first defining that object's class.  Please first " + "specify the class property first, e.g. myObject = fully_qualified_class_name " + "and then define additional properties.";
            throw new IllegalArgumentException(msg);
        }
        this.applyProperty(instance, property, value);
    }

    protected boolean isReference(String value) {
        return value != null && value.startsWith(OBJECT_REFERENCE_BEGIN_TOKEN);
    }

    protected String getId(String referenceToken) {
        return referenceToken.substring(OBJECT_REFERENCE_BEGIN_TOKEN.length());
    }

    protected Object getReferencedObject(String id) {
        Object o;
        Object object = o = this.objects != null && !this.objects.isEmpty() ? this.objects.get(id) : null;
        if (o == null) {
            String msg = "The object with id [" + id + "] has not yet been defined and therefore cannot be " + "referenced.  Please ensure objects are defined in the order in which they should be " + "created and made available for future reference.";
            throw new UnresolveableReferenceException(msg);
        }
        return o;
    }

    protected String unescapeIfNecessary(String value) {
        if (value != null && value.startsWith(ESCAPED_OBJECT_REFERENCE_BEGIN_TOKEN)) {
            return value.substring(ESCAPED_OBJECT_REFERENCE_BEGIN_TOKEN.length() - 1);
        }
        return value;
    }

    protected Object resolveReference(String reference) {
        String id = this.getId(reference);
        log.debug("Encountered object reference '{}'.  Looking up object with id '{}'", (Object)reference, (Object)id);
        Object referencedObject = this.getReferencedObject(id);
        if (referencedObject instanceof Factory) {
            return ((Factory)referencedObject).getInstance();
        }
        return referencedObject;
    }

    protected boolean isTypedProperty(Object object, String propertyName, Class clazz) {
        if (clazz == null) {
            throw new NullPointerException("type (class) argument cannot be null.");
        }
        try {
            PropertyDescriptor descriptor = this.beanUtilsBean.getPropertyUtils().getPropertyDescriptor(object, propertyName);
            if (descriptor == null) {
                String msg = "Property '" + propertyName + "' does not exist for object of " + "type " + object.getClass().getName() + ".";
                throw new ConfigurationException(msg);
            }
            Class<?> propertyClazz = descriptor.getPropertyType();
            return clazz.isAssignableFrom(propertyClazz);
        }
        catch (ConfigurationException ce) {
            throw ce;
        }
        catch (Exception e) {
            String msg = "Unable to determine if property [" + propertyName + "] represents a " + clazz.getName();
            throw new ConfigurationException(msg, e);
        }
    }

    protected Set<?> toSet(String sValue) {
        Object reference;
        String[] tokens = StringUtils.split(sValue);
        if (tokens == null || tokens.length <= 0) {
            return null;
        }
        if (tokens.length == 1 && this.isReference(tokens[0]) && (reference = this.resolveReference(tokens[0])) instanceof Set) {
            return (Set)reference;
        }
        LinkedHashSet<String> setTokens = new LinkedHashSet<String>(Arrays.asList(tokens));
        LinkedHashSet<Object> values = new LinkedHashSet<Object>(setTokens.size());
        for (String token : setTokens) {
            Object value = this.resolveValue(token);
            values.add(value);
        }
        return values;
    }

    protected Map<?, ?> toMap(String sValue) {
        Object reference;
        String[] tokens = StringUtils.split(sValue, ',', '\"', '\"', true, true);
        if (tokens == null || tokens.length <= 0) {
            return null;
        }
        if (tokens.length == 1 && this.isReference(tokens[0]) && (reference = this.resolveReference(tokens[0])) instanceof Map) {
            return (Map)reference;
        }
        LinkedHashMap<String, String> mapTokens = new LinkedHashMap<String, String>(tokens.length);
        for (String token : tokens) {
            String[] kvPair = StringUtils.split(token, ':');
            if (kvPair == null || kvPair.length != 2) {
                String msg = "Map property value [" + sValue + "] contained key-value pair token [" + token + "] that does not properly split to a single key and pair.  This must be the " + "case for all map entries.";
                throw new ConfigurationException(msg);
            }
            mapTokens.put(kvPair[0], kvPair[1]);
        }
        LinkedHashMap<Object, Object> map = new LinkedHashMap<Object, Object>(mapTokens.size());
        for (Map.Entry entry : mapTokens.entrySet()) {
            Object key = this.resolveValue((String)entry.getKey());
            Object value = this.resolveValue((String)entry.getValue());
            map.put(key, value);
        }
        return map;
    }

    protected Collection<?> toCollection(String sValue) {
        Object reference;
        String[] tokens = StringUtils.split(sValue);
        if (tokens == null || tokens.length <= 0) {
            return null;
        }
        if (tokens.length == 1 && this.isReference(tokens[0]) && (reference = this.resolveReference(tokens[0])) instanceof Collection) {
            return (Collection)reference;
        }
        ArrayList<Object> values = new ArrayList<Object>(tokens.length);
        for (String token : tokens) {
            Object value = this.resolveValue(token);
            values.add(value);
        }
        return values;
    }

    protected List<?> toList(String sValue) {
        Object reference;
        String[] tokens = StringUtils.split(sValue);
        if (tokens == null || tokens.length <= 0) {
            return null;
        }
        if (tokens.length == 1 && this.isReference(tokens[0]) && (reference = this.resolveReference(tokens[0])) instanceof List) {
            return (List)reference;
        }
        ArrayList<Object> values = new ArrayList<Object>(tokens.length);
        for (String token : tokens) {
            Object value = this.resolveValue(token);
            values.add(value);
        }
        return values;
    }

    protected byte[] toBytes(String sValue) {
        byte[] bytes;
        if (sValue == null) {
            return null;
        }
        if (sValue.startsWith(HEX_BEGIN_TOKEN)) {
            String hex = sValue.substring(HEX_BEGIN_TOKEN.length());
            bytes = Hex.decode(hex);
        } else {
            bytes = Base64.decode(sValue);
        }
        return bytes;
    }

    protected Object resolveValue(String stringValue) {
        Object value = this.isReference(stringValue) ? this.resolveReference(stringValue) : this.unescapeIfNecessary(stringValue);
        return value;
    }

    protected String checkForNullOrEmptyLiteral(String stringValue) {
        if (stringValue == null) {
            return null;
        }
        if (stringValue.equals("\"null\"")) {
            return NULL_VALUE_TOKEN;
        }
        if (stringValue.equals("\"\"\"\"")) {
            return EMPTY_STRING_VALUE_TOKEN;
        }
        return stringValue;
    }

    protected void applyProperty(Object object, String propertyPath, Object value) {
        int mapBegin = propertyPath.indexOf(91);
        int mapEnd = -1;
        String mapPropertyPath = null;
        String keyString = null;
        String remaining = null;
        if (mapBegin >= 0) {
            mapPropertyPath = propertyPath.substring(0, mapBegin);
            mapEnd = propertyPath.indexOf(93, mapBegin);
            keyString = propertyPath.substring(mapBegin + 1, mapEnd);
            if (propertyPath.length() > mapEnd + 1 && (remaining = propertyPath.substring(mapEnd + 1)).startsWith(".")) {
                remaining = StringUtils.clean(remaining.substring(1));
            }
        }
        if (remaining == null) {
            if (keyString == null) {
                this.setProperty(object, propertyPath, value);
            } else if (this.isTypedProperty(object, mapPropertyPath, Map.class)) {
                Map map = (Map)this.getProperty(object, mapPropertyPath);
                Object mapKey = this.resolveValue(keyString);
                map.put(mapKey, value);
            } else {
                int index = Integer.valueOf(keyString);
                this.setIndexedProperty(object, mapPropertyPath, index, value);
            }
        } else {
            Object referencedValue = null;
            if (this.isTypedProperty(object, mapPropertyPath, Map.class)) {
                Map map = (Map)this.getProperty(object, mapPropertyPath);
                Object mapKey = this.resolveValue(keyString);
                referencedValue = map.get(mapKey);
            } else {
                int index = Integer.valueOf(keyString);
                referencedValue = this.getIndexedProperty(object, mapPropertyPath, index);
            }
            if (referencedValue == null) {
                throw new ConfigurationException("Referenced map/array value '" + mapPropertyPath + "[" + keyString + "]' does not exist.");
            }
            this.applyProperty(referencedValue, remaining, value);
        }
    }

    private void setProperty(Object object, String propertyPath, Object value) {
        try {
            if (log.isTraceEnabled()) {
                log.trace("Applying property [{}] value [{}] on object of type [{}]", new Object[]{propertyPath, value, object.getClass().getName()});
            }
            this.beanUtilsBean.setProperty(object, propertyPath, value);
        }
        catch (Exception e) {
            String msg = "Unable to set property '" + propertyPath + "' with value [" + value + "] on object " + "of type " + (object != null ? object.getClass().getName() : null) + ".  If " + "'" + value + "' is a reference to another (previously defined) object, prefix it with " + "'" + OBJECT_REFERENCE_BEGIN_TOKEN + "' to indicate that the referenced " + "object should be used as the actual value.  " + "For example, " + OBJECT_REFERENCE_BEGIN_TOKEN + value;
            throw new ConfigurationException(msg, e);
        }
    }

    private Object getProperty(Object object, String propertyPath) {
        try {
            return this.beanUtilsBean.getPropertyUtils().getProperty(object, propertyPath);
        }
        catch (Exception e) {
            throw new ConfigurationException("Unable to access property '" + propertyPath + "'", e);
        }
    }

    private void setIndexedProperty(Object object, String propertyPath, int index, Object value) {
        try {
            this.beanUtilsBean.getPropertyUtils().setIndexedProperty(object, propertyPath, index, value);
        }
        catch (Exception e) {
            throw new ConfigurationException("Unable to set array property '" + propertyPath + "'", e);
        }
    }

    private Object getIndexedProperty(Object object, String propertyPath, int index) {
        try {
            return this.beanUtilsBean.getPropertyUtils().getIndexedProperty(object, propertyPath, index);
        }
        catch (Exception e) {
            throw new ConfigurationException("Unable to acquire array property '" + propertyPath + "'", e);
        }
    }

    protected boolean isIndexedPropertyAssignment(String propertyPath) {
        return propertyPath.endsWith("]");
    }

    protected void applyProperty(Object object, String propertyName, String stringValue) {
        Object value;
        if (NULL_VALUE_TOKEN.equals(stringValue)) {
            value = null;
        } else if (EMPTY_STRING_VALUE_TOKEN.equals(stringValue)) {
            value = "";
        } else if (this.isIndexedPropertyAssignment(propertyName)) {
            String checked = this.checkForNullOrEmptyLiteral(stringValue);
            value = this.resolveValue(checked);
        } else if (this.isTypedProperty(object, propertyName, Set.class)) {
            value = this.toSet(stringValue);
        } else if (this.isTypedProperty(object, propertyName, Map.class)) {
            value = this.toMap(stringValue);
        } else if (this.isTypedProperty(object, propertyName, List.class)) {
            value = this.toList(stringValue);
        } else if (this.isTypedProperty(object, propertyName, Collection.class)) {
            value = this.toCollection(stringValue);
        } else if (this.isTypedProperty(object, propertyName, byte[].class)) {
            value = this.toBytes(stringValue);
        } else if (this.isTypedProperty(object, propertyName, ByteSource.class)) {
            byte[] bytes = this.toBytes(stringValue);
            value = ByteSource.Util.bytes(bytes);
        } else {
            String checked = this.checkForNullOrEmptyLiteral(stringValue);
            value = this.resolveValue(checked);
        }
        this.applyProperty(object, propertyName, value);
    }

    private Interpolator createInterpolator() {
        if (ClassUtils.isAvailable("org.apache.commons.configuration2.interpol.ConfigurationInterpolator")) {
            return new CommonsInterpolator();
        }
        return new DefaultInterpolator();
    }

    public void setInterpolator(Interpolator interpolator) {
        this.interpolator = interpolator;
    }

    private static boolean isEmpty(Map m) {
        return m == null || m.isEmpty();
    }

    private static boolean isEmpty(Collection c) {
        return c == null || c.isEmpty();
    }

    private class AssignmentStatement
    extends Statement {
        private final String rootBeanName;

        private AssignmentStatement(String lhs, String rhs) {
            super(lhs, rhs);
            int index = lhs.indexOf(46);
            this.rootBeanName = lhs.substring(0, index);
        }

        @Override
        protected Object doExecute() {
            ReflectionBuilder.this.applyProperty(this.lhs, this.rhs, ReflectionBuilder.this.objects);
            Object bean = ReflectionBuilder.this.objects.get(this.rootBeanName);
            this.setBean(bean);
            return null;
        }

        public String getRootBeanName() {
            return this.rootBeanName;
        }
    }

    private class InstantiationStatement
    extends Statement {
        private InstantiationStatement(String lhs, String rhs) {
            super(lhs, rhs);
        }

        @Override
        protected Object doExecute() {
            String beanName = this.lhs;
            ReflectionBuilder.this.createNewInstance(ReflectionBuilder.this.objects, beanName, this.rhs);
            Object instantiated = ReflectionBuilder.this.objects.get(beanName);
            this.setBean(instantiated);
            ReflectionBuilder.this.enableEventsIfNecessary(instantiated, beanName);
            InstantiatedBeanEvent event = new InstantiatedBeanEvent(beanName, instantiated, Collections.unmodifiableMap(ReflectionBuilder.this.objects));
            ReflectionBuilder.this.eventBus.publish(event);
            return instantiated;
        }
    }

    private abstract class Statement {
        protected final String lhs;
        protected final String rhs;
        protected Object bean;
        private Object result;
        private boolean executed;
        private BeanConfiguration beanConfiguration;

        private Statement(String lhs, String rhs) {
            this.lhs = lhs;
            this.rhs = rhs;
            this.executed = false;
        }

        public void setBeanConfiguration(BeanConfiguration bd) {
            this.beanConfiguration = bd;
        }

        public BeanConfiguration getBeanConfiguration() {
            return this.beanConfiguration;
        }

        public Object execute() {
            if (!this.isExecuted()) {
                this.result = this.doExecute();
                this.executed = true;
            }
            if (!this.getBeanConfiguration().isGlobalConfig()) {
                Assert.notNull(this.bean, "Implementation must set the root bean for which it executed.");
            }
            return this.result;
        }

        public Object getBean() {
            return this.bean;
        }

        protected void setBean(Object bean) {
            this.bean = bean;
            if (this.beanConfiguration.getBean() == null) {
                this.beanConfiguration.setBean(bean);
            }
        }

        public Object getResult() {
            return this.result;
        }

        protected abstract Object doExecute();

        public boolean isExecuted() {
            return this.executed;
        }
    }

    private class BeanConfiguration {
        private final InstantiationStatement instantiationStatement;
        private final List<AssignmentStatement> assignments = new ArrayList<AssignmentStatement>();
        private final String beanName;
        private Object bean;

        private BeanConfiguration(InstantiationStatement statement) {
            statement.setBeanConfiguration(this);
            this.instantiationStatement = statement;
            this.beanName = statement.lhs;
        }

        private BeanConfiguration(AssignmentStatement as) {
            this.instantiationStatement = null;
            this.beanName = as.getRootBeanName();
            this.add(as);
        }

        public String getBeanName() {
            return this.beanName;
        }

        public boolean isGlobalConfig() {
            return ReflectionBuilder.GLOBAL_PROPERTY_PREFIX.equals(this.getBeanName());
        }

        public void add(AssignmentStatement as) {
            as.setBeanConfiguration(this);
            this.assignments.add(as);
        }

        public void setBean(Object bean) {
            this.bean = bean;
        }

        public Object getBean() {
            return this.bean;
        }

        public boolean isExecuted() {
            if (this.instantiationStatement != null && !this.instantiationStatement.isExecuted()) {
                return false;
            }
            for (AssignmentStatement as : this.assignments) {
                if (as.isExecuted()) continue;
                return false;
            }
            return true;
        }
    }

    private class BeanConfigurationProcessor {
        private final List<Statement> statements = new ArrayList<Statement>();
        private final List<BeanConfiguration> beanConfigurations = new ArrayList<BeanConfiguration>();

        private BeanConfigurationProcessor() {
        }

        public void add(Statement statement) {
            this.statements.add(statement);
            if (statement instanceof InstantiationStatement) {
                InstantiationStatement is = (InstantiationStatement)statement;
                this.beanConfigurations.add(new BeanConfiguration(is));
            } else {
                AssignmentStatement as = (AssignmentStatement)statement;
                boolean addedToConfig = false;
                String beanName = as.getRootBeanName();
                for (int i = this.beanConfigurations.size() - 1; i >= 0; --i) {
                    BeanConfiguration mostRecent = this.beanConfigurations.get(i);
                    String mostRecentBeanName = mostRecent.getBeanName();
                    if (!beanName.equals(mostRecentBeanName)) continue;
                    mostRecent.add(as);
                    addedToConfig = true;
                    break;
                }
                if (!addedToConfig) {
                    this.beanConfigurations.add(new BeanConfiguration(as));
                }
            }
        }

        public void execute() {
            for (Statement statement : this.statements) {
                BeanEvent event;
                statement.execute();
                BeanConfiguration bd = statement.getBeanConfiguration();
                if (!bd.isExecuted()) continue;
                if (bd.getBeanName().equals(ReflectionBuilder.EVENT_BUS_NAME)) {
                    EventBus eventBus = (EventBus)bd.getBean();
                    ReflectionBuilder.this.enableEvents(eventBus);
                }
                if (!bd.isGlobalConfig()) {
                    event = new ConfiguredBeanEvent(bd.getBeanName(), bd.getBean(), Collections.unmodifiableMap(ReflectionBuilder.this.objects));
                    ReflectionBuilder.this.eventBus.publish(event);
                }
                LifecycleUtils.init(bd.getBean());
                if (bd.isGlobalConfig()) continue;
                event = new InitializedBeanEvent(bd.getBeanName(), bd.getBean(), Collections.unmodifiableMap(ReflectionBuilder.this.objects));
                ReflectionBuilder.this.eventBus.publish(event);
            }
        }
    }
}

