/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.traffic.executor;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import org.apache.shardingsphere.infra.executor.sql.context.SQLUnit;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.driver.jdbc.JDBCExecutionUnit;
import org.apache.shardingsphere.traffic.executor.TrafficExecutorCallback;

public final class TrafficExecutor
implements AutoCloseable {
    private Statement statement;

    public <T> T execute(JDBCExecutionUnit executionUnit, TrafficExecutorCallback<T> callback) throws SQLException {
        SQLUnit sqlUnit = executionUnit.getExecutionUnit().getSqlUnit();
        this.cacheStatement(sqlUnit.getParameters(), executionUnit.getStorageResource());
        return callback.execute(this.statement, sqlUnit.getSql());
    }

    private void cacheStatement(List<Object> parameters, Statement statement) throws SQLException {
        this.statement = statement;
        this.setParameters(statement, parameters);
    }

    private void setParameters(Statement statement, List<Object> parameters) throws SQLException {
        if (!(statement instanceof PreparedStatement)) {
            return;
        }
        int index = 1;
        for (Object each : parameters) {
            ((PreparedStatement)statement).setObject(index++, each);
        }
    }

    public ResultSet getResultSet() throws SQLException {
        return this.statement.getResultSet();
    }

    @Override
    public void close() throws SQLException {
        if (null != this.statement) {
            Connection connection = this.statement.getConnection();
            this.statement.close();
            connection.close();
        }
    }
}

