/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.manager.standalone;

import java.sql.SQLException;
import org.apache.shardingsphere.infra.config.mode.PersistRepositoryConfiguration;
import org.apache.shardingsphere.infra.instance.ComputeNodeInstance;
import org.apache.shardingsphere.infra.instance.InstanceContext;
import org.apache.shardingsphere.infra.instance.workerid.WorkerIdGenerator;
import org.apache.shardingsphere.infra.lock.LockContext;
import org.apache.shardingsphere.infra.util.eventbus.EventBusContext;
import org.apache.shardingsphere.mode.lock.GlobalLockContext;
import org.apache.shardingsphere.mode.manager.ContextManager;
import org.apache.shardingsphere.mode.manager.ContextManagerBuilder;
import org.apache.shardingsphere.mode.manager.ContextManagerBuilderParameter;
import org.apache.shardingsphere.mode.manager.standalone.subscriber.ProcessStandaloneSubscriber;
import org.apache.shardingsphere.mode.manager.standalone.workerid.generator.StandaloneWorkerIdGenerator;
import org.apache.shardingsphere.mode.metadata.MetaDataContexts;
import org.apache.shardingsphere.mode.metadata.MetaDataContextsFactory;
import org.apache.shardingsphere.mode.metadata.persist.MetaDataPersistService;
import org.apache.shardingsphere.mode.persist.PersistRepository;
import org.apache.shardingsphere.mode.repository.standalone.StandalonePersistRepository;
import org.apache.shardingsphere.mode.repository.standalone.StandalonePersistRepositoryFactory;

public final class StandaloneContextManagerBuilder
implements ContextManagerBuilder {
    public ContextManager build(ContextManagerBuilderParameter param) throws SQLException {
        StandalonePersistRepository repository = StandalonePersistRepositoryFactory.getInstance((PersistRepositoryConfiguration)param.getModeConfiguration().getRepository());
        MetaDataPersistService persistService = new MetaDataPersistService((PersistRepository)repository);
        this.persistConfigurations(persistService, param);
        InstanceContext instanceContext = this.buildInstanceContext(param);
        new ProcessStandaloneSubscriber(instanceContext.getEventBusContext());
        MetaDataContexts metaDataContexts = MetaDataContextsFactory.create((MetaDataPersistService)persistService, (ContextManagerBuilderParameter)param, (InstanceContext)instanceContext);
        return new ContextManager(metaDataContexts, instanceContext);
    }

    private void persistConfigurations(MetaDataPersistService persistService, ContextManagerBuilderParameter param) {
        if (!param.isEmpty()) {
            persistService.persistConfigurations(param.getDatabaseConfigs(), param.getGlobalRuleConfigs(), param.getProps());
        }
    }

    private InstanceContext buildInstanceContext(ContextManagerBuilderParameter param) {
        return new InstanceContext(new ComputeNodeInstance(param.getInstanceMetaData()), (WorkerIdGenerator)new StandaloneWorkerIdGenerator(), param.getModeConfiguration(), (LockContext)new GlobalLockContext(null), new EventBusContext());
    }

    public String getType() {
        return "Standalone";
    }

    public boolean isDefault() {
        return true;
    }
}

