/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sqlfederation.optimizer.metadata.filter;

import java.util.List;
import lombok.Generated;
import org.apache.calcite.DataContext;
import org.apache.calcite.linq4j.Enumerable;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.schema.ProjectableFilterableTable;
import org.apache.calcite.schema.Statistic;
import org.apache.calcite.schema.impl.AbstractTable;
import org.apache.shardingsphere.infra.database.type.DatabaseType;
import org.apache.shardingsphere.infra.metadata.database.schema.decorator.model.ShardingSphereTable;
import org.apache.shardingsphere.sqlfederation.optimizer.executor.FilterableScanNodeExecutorContext;
import org.apache.shardingsphere.sqlfederation.optimizer.executor.TableScanExecutor;
import org.apache.shardingsphere.sqlfederation.optimizer.metadata.statistic.FederationStatistic;
import org.apache.shardingsphere.sqlfederation.optimizer.util.SQLFederationDataTypeUtil;

public final class FilterableTable
extends AbstractTable
implements ProjectableFilterableTable {
    private final ShardingSphereTable table;
    private final TableScanExecutor executor;
    private final FederationStatistic statistic;
    private final DatabaseType protocolType;

    public RelDataType getRowType(RelDataTypeFactory typeFactory) {
        return SQLFederationDataTypeUtil.createRelDataType(this.table, this.protocolType, typeFactory);
    }

    public Enumerable<Object[]> scan(DataContext root, List<RexNode> filters, int[] projects) {
        return this.executor.execute(this.table, new FilterableScanNodeExecutorContext(root, filters, projects));
    }

    public Statistic getStatistic() {
        return this.statistic;
    }

    @Generated
    public FilterableTable(ShardingSphereTable table, TableScanExecutor executor, FederationStatistic statistic, DatabaseType protocolType) {
        this.table = table;
        this.executor = executor;
        this.statistic = statistic;
        this.protocolType = protocolType;
    }
}

