/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.singletable.route.engine;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.infra.datanode.DataNode;
import org.apache.shardingsphere.infra.metadata.database.schema.QualifiedTable;
import org.apache.shardingsphere.infra.route.context.RouteContext;
import org.apache.shardingsphere.infra.route.context.RouteMapper;
import org.apache.shardingsphere.infra.route.context.RouteUnit;
import org.apache.shardingsphere.singletable.exception.SingleTableNotFoundException;
import org.apache.shardingsphere.singletable.route.engine.SingleTableRouteEngine;
import org.apache.shardingsphere.singletable.rule.SingleTableRule;
import org.apache.shardingsphere.sql.parser.sql.common.statement.SQLStatement;
import org.apache.shardingsphere.sql.parser.sql.common.statement.ddl.AlterTableStatement;
import org.apache.shardingsphere.sql.parser.sql.common.statement.ddl.CreateTableStatement;
import org.apache.shardingsphere.sql.parser.sql.common.statement.ddl.DropTableStatement;
import org.apache.shardingsphere.sql.parser.sql.common.statement.dml.SelectStatement;

public final class SingleTableStandardRouteEngine
implements SingleTableRouteEngine {
    private final Collection<QualifiedTable> singleTableNames;
    private final SQLStatement sqlStatement;

    @Override
    public void route(RouteContext routeContext, SingleTableRule rule) {
        if (routeContext.getRouteUnits().isEmpty() || this.sqlStatement instanceof SelectStatement) {
            this.route0(routeContext, rule);
        } else {
            RouteContext newRouteContext = new RouteContext();
            this.route0(newRouteContext, rule);
            this.combineRouteContext(routeContext, newRouteContext);
        }
    }

    private void combineRouteContext(RouteContext routeContext, RouteContext newRouteContext) {
        Map<String, RouteUnit> dataSourceRouteUnits = this.getDataSourceRouteUnits(newRouteContext);
        routeContext.getRouteUnits().removeIf(each -> !dataSourceRouteUnits.containsKey(each.getDataSourceMapper().getLogicName()));
        for (Map.Entry<String, RouteUnit> entry : dataSourceRouteUnits.entrySet()) {
            routeContext.putRouteUnit(entry.getValue().getDataSourceMapper(), entry.getValue().getTableMappers());
        }
    }

    private Map<String, RouteUnit> getDataSourceRouteUnits(RouteContext newRouteContext) {
        return newRouteContext.getRouteUnits().stream().collect(Collectors.toMap(each -> each.getDataSourceMapper().getLogicName(), Function.identity()));
    }

    private void route0(RouteContext routeContext, SingleTableRule rule) {
        if (this.sqlStatement instanceof CreateTableStatement) {
            String dataSourceName = rule.assignNewDataSourceName();
            String tableName = this.singleTableNames.iterator().next().getTableName();
            routeContext.getRouteUnits().add(new RouteUnit(new RouteMapper(dataSourceName, dataSourceName), Collections.singleton(new RouteMapper(tableName, tableName))));
        } else if (this.sqlStatement instanceof AlterTableStatement || this.sqlStatement instanceof DropTableStatement || rule.isAllTablesInSameDataSource(routeContext, this.singleTableNames)) {
            this.fillRouteContext(rule, routeContext, rule.getSingleTableNames(this.singleTableNames));
        }
    }

    private void fillRouteContext(SingleTableRule singleTableRule, RouteContext routeContext, Collection<QualifiedTable> logicTables) {
        for (QualifiedTable each : logicTables) {
            String tableName = each.getTableName();
            Optional<DataNode> dataNode = singleTableRule.findSingleTableDataNode(each.getSchemaName(), tableName);
            if (!dataNode.isPresent()) {
                throw new SingleTableNotFoundException(tableName);
            }
            String dataSource = dataNode.get().getDataSourceName();
            routeContext.putRouteUnit(new RouteMapper(dataSource, dataSource), Collections.singletonList(new RouteMapper(tableName, tableName)));
        }
    }

    @Generated
    public SingleTableStandardRouteEngine(Collection<QualifiedTable> singleTableNames, SQLStatement sqlStatement) {
        this.singleTableNames = singleTableNames;
        this.sqlStatement = sqlStatement;
    }
}

