/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.readwritesplitting.strategy.type;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import lombok.Generated;
import org.apache.shardingsphere.infra.rule.identifier.type.DynamicDataSourceContainedRule;
import org.apache.shardingsphere.readwritesplitting.strategy.ReadwriteSplittingStrategy;

public final class DynamicReadwriteSplittingStrategy
implements ReadwriteSplittingStrategy {
    private final String autoAwareDataSourceName;
    private final boolean allowWriteDataSourceQuery;
    private final DynamicDataSourceContainedRule dynamicDataSource;

    @Override
    public String getWriteDataSource() {
        return this.dynamicDataSource.getPrimaryDataSourceName(this.autoAwareDataSourceName);
    }

    @Override
    public List<String> getReadDataSources() {
        return new ArrayList<String>(this.dynamicDataSource.getReplicaDataSourceNames(this.autoAwareDataSourceName));
    }

    @Override
    public Collection<String> getAllDataSources() {
        LinkedList<String> result = new LinkedList<String>();
        result.add(this.dynamicDataSource.getPrimaryDataSourceName(this.autoAwareDataSourceName));
        result.addAll(this.dynamicDataSource.getReplicaDataSourceNames(this.autoAwareDataSourceName));
        return result;
    }

    @Generated
    public DynamicReadwriteSplittingStrategy(String autoAwareDataSourceName, boolean allowWriteDataSourceQuery, DynamicDataSourceContainedRule dynamicDataSource) {
        this.autoAwareDataSourceName = autoAwareDataSourceName;
        this.allowWriteDataSourceQuery = allowWriteDataSourceQuery;
        this.dynamicDataSource = dynamicDataSource;
    }

    @Generated
    public String getAutoAwareDataSourceName() {
        return this.autoAwareDataSourceName;
    }

    @Generated
    public boolean isAllowWriteDataSourceQuery() {
        return this.allowWriteDataSourceQuery;
    }

    @Generated
    public DynamicDataSourceContainedRule getDynamicDataSource() {
        return this.dynamicDataSource;
    }
}

