/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.readwritesplitting.strategy;

import com.google.common.base.Strings;
import java.util.Collection;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.infra.rule.ShardingSphereRule;
import org.apache.shardingsphere.infra.rule.identifier.type.DynamicDataSourceContainedRule;
import org.apache.shardingsphere.readwritesplitting.api.rule.ReadwriteSplittingDataSourceRuleConfiguration;
import org.apache.shardingsphere.readwritesplitting.api.strategy.DynamicReadwriteSplittingStrategyConfiguration;
import org.apache.shardingsphere.readwritesplitting.api.strategy.StaticReadwriteSplittingStrategyConfiguration;
import org.apache.shardingsphere.readwritesplitting.strategy.ReadwriteSplittingStrategy;
import org.apache.shardingsphere.readwritesplitting.strategy.type.DynamicReadwriteSplittingStrategy;
import org.apache.shardingsphere.readwritesplitting.strategy.type.StaticReadwriteSplittingStrategy;

public final class ReadwriteSplittingStrategyFactory {
    public static ReadwriteSplittingStrategy newInstance(ReadwriteSplittingDataSourceRuleConfiguration readwriteSplittingConfig, Collection<ShardingSphereRule> builtRules) {
        return null == readwriteSplittingConfig.getStaticStrategy() ? ReadwriteSplittingStrategyFactory.createDynamicReadwriteSplittingStrategy(readwriteSplittingConfig.getDynamicStrategy(), builtRules) : ReadwriteSplittingStrategyFactory.createStaticReadwriteSplittingStrategy(readwriteSplittingConfig.getStaticStrategy());
    }

    private static StaticReadwriteSplittingStrategy createStaticReadwriteSplittingStrategy(StaticReadwriteSplittingStrategyConfiguration staticConfig) {
        return new StaticReadwriteSplittingStrategy(staticConfig.getWriteDataSourceName(), staticConfig.getReadDataSourceNames());
    }

    private static DynamicReadwriteSplittingStrategy createDynamicReadwriteSplittingStrategy(DynamicReadwriteSplittingStrategyConfiguration dynamicConfig, Collection<ShardingSphereRule> builtRules) {
        Optional<ShardingSphereRule> dynamicDataSourceStrategy = builtRules.stream().filter(each -> each instanceof DynamicDataSourceContainedRule).findFirst();
        boolean allowWriteDataSourceQuery = Strings.isNullOrEmpty((String)dynamicConfig.getWriteDataSourceQueryEnabled()) ? Boolean.TRUE : Boolean.parseBoolean(dynamicConfig.getWriteDataSourceQueryEnabled());
        return new DynamicReadwriteSplittingStrategy(dynamicConfig.getAutoAwareDataSourceName(), allowWriteDataSourceQuery, (DynamicDataSourceContainedRule)dynamicDataSourceStrategy.get());
    }

    @Generated
    private ReadwriteSplittingStrategyFactory() {
    }
}

