/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.readwritesplitting.rule;

import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import lombok.Generated;
import org.apache.shardingsphere.infra.rule.ShardingSphereRule;
import org.apache.shardingsphere.readwritesplitting.api.rule.ReadwriteSplittingDataSourceRuleConfiguration;
import org.apache.shardingsphere.readwritesplitting.spi.ReadQueryLoadBalanceAlgorithm;
import org.apache.shardingsphere.readwritesplitting.strategy.ReadwriteSplittingStrategy;
import org.apache.shardingsphere.readwritesplitting.strategy.ReadwriteSplittingStrategyFactory;
import org.apache.shardingsphere.readwritesplitting.strategy.type.DynamicReadwriteSplittingStrategy;

public final class ReadwriteSplittingDataSourceRule {
    private final String name;
    private final ReadQueryLoadBalanceAlgorithm loadBalancer;
    private final ReadwriteSplittingStrategy readwriteSplittingStrategy;
    private final Collection<String> disabledDataSourceNames = new HashSet<String>();

    public ReadwriteSplittingDataSourceRule(ReadwriteSplittingDataSourceRuleConfiguration config, ReadQueryLoadBalanceAlgorithm loadBalancer, Collection<ShardingSphereRule> builtRules) {
        this.name = config.getName();
        this.loadBalancer = loadBalancer;
        this.readwriteSplittingStrategy = ReadwriteSplittingStrategyFactory.newInstance(config, builtRules);
    }

    public String getWriteDataSource() {
        return this.readwriteSplittingStrategy.getWriteDataSource();
    }

    public void updateDisabledDataSourceNames(String dataSourceName, boolean isDisabled) {
        if (isDisabled) {
            this.disabledDataSourceNames.add(dataSourceName);
        } else {
            this.disabledDataSourceNames.remove(dataSourceName);
        }
    }

    public List<String> getEnabledReplicaDataSources() {
        List<String> result = this.readwriteSplittingStrategy.getReadDataSources();
        if (this.readwriteSplittingStrategy instanceof DynamicReadwriteSplittingStrategy) {
            return result;
        }
        if (!this.disabledDataSourceNames.isEmpty()) {
            result = new LinkedList<String>(result);
            result.removeIf(this.disabledDataSourceNames::contains);
        }
        return result;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public ReadQueryLoadBalanceAlgorithm getLoadBalancer() {
        return this.loadBalancer;
    }

    @Generated
    public ReadwriteSplittingStrategy getReadwriteSplittingStrategy() {
        return this.readwriteSplittingStrategy;
    }
}

