/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.readwritesplitting.checker;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.shardingsphere.infra.config.algorithm.AlgorithmConfiguration;
import org.apache.shardingsphere.readwritesplitting.api.ReadwriteSplittingRuleConfiguration;
import org.apache.shardingsphere.readwritesplitting.api.rule.ReadwriteSplittingDataSourceRuleConfiguration;
import org.apache.shardingsphere.readwritesplitting.checker.AbstractReadwriteSplittingRuleConfigurationChecker;
import org.apache.shardingsphere.readwritesplitting.factory.ReadQueryLoadBalanceAlgorithmFactory;
import org.apache.shardingsphere.readwritesplitting.spi.ReadQueryLoadBalanceAlgorithm;

public final class ReadwriteSplittingRuleConfigurationChecker
extends AbstractReadwriteSplittingRuleConfigurationChecker<ReadwriteSplittingRuleConfiguration> {
    @Override
    protected Collection<ReadwriteSplittingDataSourceRuleConfiguration> getDataSources(ReadwriteSplittingRuleConfiguration config) {
        return config.getDataSources();
    }

    @Override
    protected Map<String, ReadQueryLoadBalanceAlgorithm> getLoadBalancer(ReadwriteSplittingRuleConfiguration config) {
        LinkedHashMap<String, ReadQueryLoadBalanceAlgorithm> result = new LinkedHashMap<String, ReadQueryLoadBalanceAlgorithm>(config.getLoadBalancers().size(), 1.0f);
        config.getLoadBalancers().forEach((key, value) -> result.put((String)key, ReadQueryLoadBalanceAlgorithmFactory.newInstance((AlgorithmConfiguration)value)));
        return result;
    }

    public int getOrder() {
        return 30;
    }

    public Class<ReadwriteSplittingRuleConfiguration> getTypeClass() {
        return ReadwriteSplittingRuleConfiguration.class;
    }
}

