/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.readwritesplitting.algorithm.loadbalance;

import java.util.List;
import java.util.Properties;
import java.util.concurrent.ThreadLocalRandom;
import lombok.Generated;
import org.apache.shardingsphere.infra.context.transaction.TransactionConnectionContext;
import org.apache.shardingsphere.readwritesplitting.spi.ReadQueryLoadBalanceAlgorithm;

public final class FixedReplicaRandomReadQueryLoadBalanceAlgorithm
implements ReadQueryLoadBalanceAlgorithm {
    private Properties props = new Properties();

    public void init(Properties props) {
        this.props = props;
    }

    public String getDataSource(String name, String writeDataSourceName, List<String> readDataSourceNames, TransactionConnectionContext context) {
        if (context.isInTransaction()) {
            if (null == context.getReadWriteSplitReplicaRoute()) {
                context.setReadWriteSplitReplicaRoute(readDataSourceNames.get(ThreadLocalRandom.current().nextInt(readDataSourceNames.size())));
            }
            return context.getReadWriteSplitReplicaRoute();
        }
        return readDataSourceNames.get(ThreadLocalRandom.current().nextInt(readDataSourceNames.size()));
    }

    public String getType() {
        return "FIXED_REPLICA_RANDOM";
    }

    @Generated
    public Properties getProps() {
        return this.props;
    }
}

