/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.hint;

import java.util.Collection;
import java.util.Map;
import java.util.Properties;
import lombok.Generated;
import org.apache.shardingsphere.infra.hint.SQLHintProperties;
import org.apache.shardingsphere.infra.hint.SQLHintPropertiesKey;
import org.apache.shardingsphere.infra.hint.SQLHintUtils;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.CommentSegment;
import org.apache.shardingsphere.sql.parser.sql.common.statement.AbstractSQLStatement;
import org.apache.shardingsphere.sql.parser.sql.common.statement.SQLStatement;

public final class SQLHintExtractor {
    private static final SQLHintProperties DEFAULT_SQL_HINT_PROPERTIES = new SQLHintProperties(new Properties());
    private final SQLHintProperties sqlHintProperties;

    public SQLHintExtractor(SQLStatement sqlStatement) {
        this.sqlHintProperties = sqlStatement instanceof AbstractSQLStatement && !((AbstractSQLStatement)sqlStatement).getCommentSegments().isEmpty() ? this.extract((AbstractSQLStatement)sqlStatement) : DEFAULT_SQL_HINT_PROPERTIES;
    }

    private SQLHintProperties extract(AbstractSQLStatement statement) {
        Properties props = new Properties();
        for (CommentSegment each : statement.getCommentSegments()) {
            props.putAll((Map<?, ?>)SQLHintUtils.getSQLHintProps(each.getText()));
        }
        return new SQLHintProperties(props);
    }

    public boolean isHintWriteRouteOnly() {
        return (Boolean)this.sqlHintProperties.getValue(SQLHintPropertiesKey.WRITE_ROUTE_ONLY_KEY);
    }

    public boolean isHintSkipEncryptRewrite() {
        return (Boolean)this.sqlHintProperties.getValue(SQLHintPropertiesKey.SKIP_ENCRYPT_REWRITE_KEY);
    }

    public Collection<String> findDisableAuditNames() {
        return SQLHintUtils.getSplitterSQLHintValue((String)this.sqlHintProperties.getValue(SQLHintPropertiesKey.DISABLE_AUDIT_NAMES));
    }

    @Generated
    public SQLHintProperties getSqlHintProperties() {
        return this.sqlHintProperties;
    }
}

