/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.scenario.migration;

import java.sql.SQLException;
import java.util.Collections;
import java.util.HashMap;
import javax.sql.DataSource;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.shardingsphere.data.pipeline.api.config.TableNameSchemaNameMapping;
import org.apache.shardingsphere.data.pipeline.api.config.TaskConfiguration;
import org.apache.shardingsphere.data.pipeline.api.config.job.MigrationJobConfiguration;
import org.apache.shardingsphere.data.pipeline.api.datanode.JobDataNodeLine;
import org.apache.shardingsphere.data.pipeline.api.datasource.PipelineDataSourceManager;
import org.apache.shardingsphere.data.pipeline.api.datasource.PipelineDataSourceWrapper;
import org.apache.shardingsphere.data.pipeline.api.job.JobStatus;
import org.apache.shardingsphere.data.pipeline.api.job.progress.InventoryIncrementalJobItemProgress;
import org.apache.shardingsphere.data.pipeline.api.job.progress.JobItemIncrementalTasksProgress;
import org.apache.shardingsphere.data.pipeline.core.context.PipelineContext;
import org.apache.shardingsphere.data.pipeline.core.exception.PipelineIgnoredException;
import org.apache.shardingsphere.data.pipeline.core.exception.PipelineJobPrepareFailedException;
import org.apache.shardingsphere.data.pipeline.core.execute.ExecuteEngine;
import org.apache.shardingsphere.data.pipeline.core.job.progress.listener.DefaultPipelineJobProgressListener;
import org.apache.shardingsphere.data.pipeline.core.metadata.loader.PipelineTableMetaDataLoader;
import org.apache.shardingsphere.data.pipeline.core.prepare.InventoryTaskSplitter;
import org.apache.shardingsphere.data.pipeline.core.prepare.PipelineJobPreparerUtils;
import org.apache.shardingsphere.data.pipeline.core.prepare.datasource.PrepareTargetSchemasParameter;
import org.apache.shardingsphere.data.pipeline.core.prepare.datasource.PrepareTargetTablesParameter;
import org.apache.shardingsphere.data.pipeline.core.task.IncrementalTask;
import org.apache.shardingsphere.data.pipeline.scenario.migration.MigrationJobAPI;
import org.apache.shardingsphere.data.pipeline.scenario.migration.MigrationJobAPIFactory;
import org.apache.shardingsphere.data.pipeline.scenario.migration.MigrationJobItemContext;
import org.apache.shardingsphere.data.pipeline.spi.ingest.channel.PipelineChannelCreator;
import org.apache.shardingsphere.infra.database.type.DatabaseTypeFactory;
import org.apache.shardingsphere.infra.lock.LockContext;
import org.apache.shardingsphere.infra.lock.LockDefinition;
import org.apache.shardingsphere.infra.metadata.ShardingSphereMetaData;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.parser.ShardingSphereSQLParserEngine;
import org.apache.shardingsphere.mode.lock.ExclusiveLockDefinition;
import org.apache.shardingsphere.parser.rule.SQLParserRule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MigrationJobPreparer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MigrationJobPreparer.class);
    private static final MigrationJobAPI JOB_API = MigrationJobAPIFactory.getInstance();

    public void prepare(MigrationJobItemContext jobItemContext) throws SQLException {
        PipelineJobPreparerUtils.checkSourceDataSource(jobItemContext.getJobConfig().getSourceDatabaseType(), Collections.singleton(jobItemContext.getSourceDataSource()));
        if (jobItemContext.isStopping()) {
            throw new PipelineIgnoredException("Job stopping, jobId=" + jobItemContext.getJobId());
        }
        this.prepareAndCheckTargetWithLock(jobItemContext);
        if (jobItemContext.isStopping()) {
            throw new PipelineIgnoredException("Job stopping, jobId=" + jobItemContext.getJobId());
        }
        try {
            if (PipelineJobPreparerUtils.isIncrementalSupported(jobItemContext.getJobConfig().getSourceDatabaseType())) {
                this.initIncrementalTasks(jobItemContext);
                if (jobItemContext.isStopping()) {
                    throw new PipelineIgnoredException("Job stopping, jobId=" + jobItemContext.getJobId());
                }
            }
            this.initInventoryTasks(jobItemContext);
            log.info("prepare, jobId={}, shardingItem={}, inventoryTasks={}, incrementalTasks={}", new Object[]{jobItemContext.getJobId(), jobItemContext.getShardingItem(), jobItemContext.getInventoryTasks(), jobItemContext.getIncrementalTasks()});
        }
        catch (SQLException ex) {
            log.error("Scaling job preparing failed, jobId={}", (Object)jobItemContext.getJobId());
            throw new PipelineJobPrepareFailedException("Scaling job preparing failed, jobId=" + jobItemContext.getJobId(), ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void prepareAndCheckTargetWithLock(MigrationJobItemContext jobItemContext) throws SQLException {
        MigrationJobConfiguration jobConfig = jobItemContext.getJobConfig();
        String lockName = "prepare-" + jobConfig.getJobId();
        LockContext lockContext = PipelineContext.getContextManager().getInstanceContext().getLockContext();
        ExclusiveLockDefinition lockDefinition = new ExclusiveLockDefinition(lockName);
        if (null == JOB_API.getJobItemProgress(jobItemContext.getJobId(), jobItemContext.getShardingItem())) {
            JOB_API.persistJobItemProgress(jobItemContext);
        }
        if (lockContext.tryLock((LockDefinition)lockDefinition, 180000L)) {
            log.info("try lock success, jobId={}, shardingItem={}", (Object)jobConfig.getJobId(), (Object)jobItemContext.getShardingItem());
            try {
                boolean prepareFlag;
                InventoryIncrementalJobItemProgress jobItemProgress = JOB_API.getJobItemProgress(jobItemContext.getJobId(), jobItemContext.getShardingItem());
                boolean bl = prepareFlag = JobStatus.PREPARING.equals((Object)jobItemProgress.getStatus()) || JobStatus.RUNNING.equals((Object)jobItemProgress.getStatus()) || JobStatus.PREPARING_FAILURE.equals((Object)jobItemProgress.getStatus());
                if (prepareFlag) {
                    log.info("execute prepare, jobId={}, shardingItem={}, jobStatus={}", new Object[]{jobConfig.getJobId(), jobItemContext.getShardingItem(), jobItemProgress.getStatus()});
                    jobItemContext.setStatus(JobStatus.PREPARING);
                    JOB_API.updateJobItemStatus(jobConfig.getJobId(), jobItemContext.getShardingItem(), JobStatus.PREPARING);
                    this.prepareAndCheckTarget(jobItemContext);
                    for (int i = 0; i <= jobItemContext.getJobConfig().getJobShardingCount(); ++i) {
                        JOB_API.updateJobItemStatus(jobConfig.getJobId(), i, JobStatus.PREPARE_SUCCESS);
                    }
                }
            }
            finally {
                log.info("unlock, jobId={}, shardingItem={}", (Object)jobConfig.getJobId(), (Object)jobItemContext.getShardingItem());
                lockContext.unlock((LockDefinition)lockDefinition);
            }
        }
    }

    private void prepareAndCheckTarget(MigrationJobItemContext jobItemContext) throws SQLException {
        InventoryIncrementalJobItemProgress initProgress;
        if (jobItemContext.isSourceTargetDatabaseTheSame()) {
            log.info("prepare target ...");
            this.prepareTarget(jobItemContext);
        }
        if (null == (initProgress = jobItemContext.getInitProgress()) || initProgress.getStatus() == JobStatus.PREPARING_FAILURE) {
            PipelineDataSourceWrapper targetDataSource = jobItemContext.getDataSourceManager().getDataSource(jobItemContext.getTaskConfig().getImporterConfig().getDataSourceConfig());
            PipelineJobPreparerUtils.checkTargetDataSource(jobItemContext.getJobConfig().getTargetDatabaseType(), jobItemContext.getTaskConfig().getImporterConfig(), Collections.singletonList(targetDataSource));
        }
    }

    private void prepareTarget(MigrationJobItemContext jobItemContext) throws SQLException {
        MigrationJobConfiguration jobConfig = jobItemContext.getJobConfig();
        TableNameSchemaNameMapping tableNameSchemaNameMapping = jobItemContext.getTaskConfig().getDumperConfig().getTableNameSchemaNameMapping();
        String targetDatabaseType = jobConfig.getTargetDatabaseType();
        if (this.isTargetSchemaAvailable(jobConfig) && StringUtils.isNotBlank((CharSequence)jobConfig.getSourceSchemaName())) {
            PrepareTargetSchemasParameter prepareTargetSchemasParameter = new PrepareTargetSchemasParameter(Collections.singletonList(jobConfig.getTargetTableName()), DatabaseTypeFactory.getInstance((String)targetDatabaseType), jobConfig.getTargetDatabaseName(), jobItemContext.getTaskConfig().getImporterConfig().getDataSourceConfig(), jobItemContext.getDataSourceManager(), tableNameSchemaNameMapping);
            PipelineJobPreparerUtils.prepareTargetSchema(targetDatabaseType, prepareTargetSchemasParameter);
        }
        ShardingSphereMetaData metaData = PipelineContext.getContextManager().getMetaDataContexts().getMetaData();
        ShardingSphereDatabase sphereDatabase = (ShardingSphereDatabase)metaData.getDatabases().get(jobConfig.getTargetDatabaseName());
        ShardingSphereSQLParserEngine sqlParserEngine = ((SQLParserRule)metaData.getGlobalRuleMetaData().getSingleRule(SQLParserRule.class)).getSQLParserEngine(sphereDatabase.getProtocolType().getType());
        JobDataNodeLine jobDataNodeLine = JobDataNodeLine.unmarshal((String)jobConfig.getTablesFirstDataNodes());
        PipelineDataSourceWrapper dataSource = jobItemContext.getDataSourceManager().getDataSource(jobItemContext.getTaskConfig().getDumperConfig().getDataSourceConfig());
        HashMap<String, DataSource> sourceDataSourceMap = new HashMap<String, DataSource>(1, 1.0f);
        sourceDataSourceMap.put(jobConfig.getSourceResourceName(), (DataSource)dataSource);
        PrepareTargetTablesParameter prepareTargetTablesParameter = new PrepareTargetTablesParameter(jobConfig.getTargetDatabaseName(), jobItemContext.getTaskConfig().getImporterConfig().getDataSourceConfig(), sourceDataSourceMap, jobItemContext.getDataSourceManager(), jobDataNodeLine, tableNameSchemaNameMapping, sqlParserEngine);
        PipelineJobPreparerUtils.prepareTargetTables(targetDatabaseType, prepareTargetTablesParameter);
    }

    private boolean isTargetSchemaAvailable(MigrationJobConfiguration jobConfig) {
        return DatabaseTypeFactory.getInstance((String)jobConfig.getTargetDatabaseType()).isSchemaAvailable();
    }

    private void initInventoryTasks(MigrationJobItemContext jobItemContext) {
        InventoryTaskSplitter inventoryTaskSplitter = new InventoryTaskSplitter(jobItemContext.getSourceMetaDataLoader(), jobItemContext.getDataSourceManager(), jobItemContext.getJobProcessContext().getImporterExecuteEngine(), jobItemContext.getSourceDataSource(), jobItemContext.getTaskConfig(), jobItemContext.getInitProgress());
        jobItemContext.getInventoryTasks().addAll(inventoryTaskSplitter.splitInventoryData(jobItemContext));
    }

    private void initIncrementalTasks(MigrationJobItemContext jobItemContext) throws SQLException {
        PipelineChannelCreator pipelineChannelCreator = jobItemContext.getJobProcessContext().getPipelineChannelCreator();
        ExecuteEngine incrementalDumperExecuteEngine = jobItemContext.getJobProcessContext().getIncrementalDumperExecuteEngine();
        TaskConfiguration taskConfig = jobItemContext.getTaskConfig();
        PipelineDataSourceManager dataSourceManager = jobItemContext.getDataSourceManager();
        JobItemIncrementalTasksProgress initIncremental = jobItemContext.getInitProgress() == null ? null : jobItemContext.getInitProgress().getIncremental();
        taskConfig.getDumperConfig().setPosition(PipelineJobPreparerUtils.getIncrementalPosition(initIncremental, taskConfig.getDumperConfig(), dataSourceManager));
        PipelineTableMetaDataLoader sourceMetaDataLoader = jobItemContext.getSourceMetaDataLoader();
        DefaultPipelineJobProgressListener jobProgressListener = new DefaultPipelineJobProgressListener(jobItemContext.getJobId(), jobItemContext.getShardingItem());
        IncrementalTask incrementalTask = new IncrementalTask(taskConfig.getImporterConfig().getConcurrency(), taskConfig.getDumperConfig(), taskConfig.getImporterConfig(), pipelineChannelCreator, dataSourceManager, sourceMetaDataLoader, incrementalDumperExecuteEngine, jobProgressListener);
        jobItemContext.getIncrementalTasks().add(incrementalTask);
    }

    public void cleanup(MigrationJobConfiguration jobConfig) {
        try {
            PipelineJobPreparerUtils.destroyPosition(jobConfig.getJobId(), jobConfig.getSource());
        }
        catch (SQLException ex) {
            log.warn("Scaling job destroying failed", (Throwable)ex);
        }
    }
}

