/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.scenario.migration;

import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.google.gson.Gson;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.sql.DataSource;
import lombok.Generated;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.shardingsphere.data.pipeline.api.check.consistency.DataConsistencyCheckResult;
import org.apache.shardingsphere.data.pipeline.api.config.ImporterConfiguration;
import org.apache.shardingsphere.data.pipeline.api.config.TableNameSchemaNameMapping;
import org.apache.shardingsphere.data.pipeline.api.config.TaskConfiguration;
import org.apache.shardingsphere.data.pipeline.api.config.ingest.DumperConfiguration;
import org.apache.shardingsphere.data.pipeline.api.config.job.MigrationJobConfiguration;
import org.apache.shardingsphere.data.pipeline.api.config.job.PipelineJobConfiguration;
import org.apache.shardingsphere.data.pipeline.api.config.job.yaml.YamlMigrationJobConfiguration;
import org.apache.shardingsphere.data.pipeline.api.config.job.yaml.YamlMigrationJobConfigurationSwapper;
import org.apache.shardingsphere.data.pipeline.api.config.job.yaml.YamlPipelineJobConfiguration;
import org.apache.shardingsphere.data.pipeline.api.context.PipelineJobItemContext;
import org.apache.shardingsphere.data.pipeline.api.datanode.JobDataNodeEntry;
import org.apache.shardingsphere.data.pipeline.api.datanode.JobDataNodeLine;
import org.apache.shardingsphere.data.pipeline.api.datasource.PipelineDataSourceWrapper;
import org.apache.shardingsphere.data.pipeline.api.datasource.config.PipelineDataSourceConfiguration;
import org.apache.shardingsphere.data.pipeline.api.datasource.config.PipelineDataSourceConfigurationFactory;
import org.apache.shardingsphere.data.pipeline.api.datasource.config.impl.ShardingSpherePipelineDataSourceConfiguration;
import org.apache.shardingsphere.data.pipeline.api.datasource.config.impl.StandardPipelineDataSourceConfiguration;
import org.apache.shardingsphere.data.pipeline.api.datasource.config.yaml.YamlPipelineDataSourceConfiguration;
import org.apache.shardingsphere.data.pipeline.api.job.JobStatus;
import org.apache.shardingsphere.data.pipeline.api.job.JobType;
import org.apache.shardingsphere.data.pipeline.api.job.PipelineJobId;
import org.apache.shardingsphere.data.pipeline.api.job.progress.InventoryIncrementalJobItemProgress;
import org.apache.shardingsphere.data.pipeline.api.metadata.ActualTableName;
import org.apache.shardingsphere.data.pipeline.api.metadata.LogicTableName;
import org.apache.shardingsphere.data.pipeline.api.pojo.CreateMigrationJobParameter;
import org.apache.shardingsphere.data.pipeline.api.pojo.DataConsistencyCheckAlgorithmInfo;
import org.apache.shardingsphere.data.pipeline.api.pojo.MigrationJobInfo;
import org.apache.shardingsphere.data.pipeline.api.pojo.PipelineJobInfo;
import org.apache.shardingsphere.data.pipeline.core.api.PipelineAPIFactory;
import org.apache.shardingsphere.data.pipeline.core.api.PipelineJobItemAPI;
import org.apache.shardingsphere.data.pipeline.core.api.impl.AbstractPipelineJobAPIImpl;
import org.apache.shardingsphere.data.pipeline.core.api.impl.InventoryIncrementalJobItemAPIImpl;
import org.apache.shardingsphere.data.pipeline.core.api.impl.PipelineDataSourcePersistService;
import org.apache.shardingsphere.data.pipeline.core.check.consistency.DataConsistencyCalculateAlgorithmChooser;
import org.apache.shardingsphere.data.pipeline.core.check.consistency.DataConsistencyCalculateAlgorithmFactory;
import org.apache.shardingsphere.data.pipeline.core.context.PipelineContext;
import org.apache.shardingsphere.data.pipeline.core.datasource.PipelineDataSourceFactory;
import org.apache.shardingsphere.data.pipeline.core.exception.AddMigrationSourceResourceException;
import org.apache.shardingsphere.data.pipeline.core.exception.DropMigrationSourceResourceException;
import org.apache.shardingsphere.data.pipeline.core.sqlbuilder.PipelineSQLBuilderFactory;
import org.apache.shardingsphere.data.pipeline.core.util.PipelineSchemaTableUtil;
import org.apache.shardingsphere.data.pipeline.scenario.migration.MigrationDataConsistencyChecker;
import org.apache.shardingsphere.data.pipeline.scenario.migration.MigrationJobAPI;
import org.apache.shardingsphere.data.pipeline.scenario.migration.MigrationJobId;
import org.apache.shardingsphere.data.pipeline.scenario.migration.MigrationProcessContext;
import org.apache.shardingsphere.data.pipeline.spi.check.consistency.DataConsistencyCalculateAlgorithm;
import org.apache.shardingsphere.data.pipeline.spi.ratelimit.JobRateLimitAlgorithm;
import org.apache.shardingsphere.data.pipeline.spi.sqlbuilder.PipelineSQLBuilder;
import org.apache.shardingsphere.elasticjob.infra.pojo.JobConfigurationPOJO;
import org.apache.shardingsphere.infra.config.rule.RuleConfiguration;
import org.apache.shardingsphere.infra.config.rule.data.pipeline.PipelineProcessConfiguration;
import org.apache.shardingsphere.infra.database.metadata.DataSourceMetaData;
import org.apache.shardingsphere.infra.database.type.DatabaseType;
import org.apache.shardingsphere.infra.database.type.DatabaseTypeEngine;
import org.apache.shardingsphere.infra.database.type.DatabaseTypeFactory;
import org.apache.shardingsphere.infra.datanode.DataNode;
import org.apache.shardingsphere.infra.datasource.props.DataSourceProperties;
import org.apache.shardingsphere.infra.datasource.props.DataSourcePropertiesCreator;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.util.yaml.YamlEngine;
import org.apache.shardingsphere.infra.yaml.config.pojo.YamlRootConfiguration;
import org.apache.shardingsphere.infra.yaml.config.swapper.resource.YamlDataSourceConfigurationSwapper;
import org.apache.shardingsphere.infra.yaml.config.swapper.rule.YamlRuleConfigurationSwapperEngine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MigrationJobAPIImpl
extends AbstractPipelineJobAPIImpl
implements MigrationJobAPI {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MigrationJobAPIImpl.class);
    private static final YamlRuleConfigurationSwapperEngine RULE_CONFIG_SWAPPER_ENGINE = new YamlRuleConfigurationSwapperEngine();
    private static final YamlDataSourceConfigurationSwapper DATA_SOURCE_CONFIG_SWAPPER = new YamlDataSourceConfigurationSwapper();
    private final PipelineJobItemAPI jobItemAPI = new InventoryIncrementalJobItemAPIImpl();
    private final PipelineDataSourcePersistService dataSourcePersistService = new PipelineDataSourcePersistService();

    @Override
    protected JobType getJobType() {
        return JobType.MIGRATION;
    }

    @Override
    protected String marshalJobIdLeftPart(PipelineJobId pipelineJobId) {
        MigrationJobId jobId = (MigrationJobId)pipelineJobId;
        String sourceSchemaName = null != jobId.getSourceSchemaName() ? jobId.getSourceSchemaName() : "";
        String text = Joiner.on((char)'|').join((Object)jobId.getSourceResourceName(), (Object)sourceSchemaName, new Object[]{jobId.getSourceTableName(), jobId.getTargetDatabaseName(), jobId.getTargetTableName()});
        return DigestUtils.md5Hex((byte[])text.getBytes(StandardCharsets.UTF_8));
    }

    public List<MigrationJobInfo> list() {
        return super.list();
    }

    protected MigrationJobInfo getJobInfo(String jobId) {
        MigrationJobInfo result = new MigrationJobInfo(jobId);
        JobConfigurationPOJO jobConfigPOJO = this.getElasticJobConfigPOJO(jobId);
        this.fillJobInfo((PipelineJobInfo)result, jobConfigPOJO);
        MigrationJobConfiguration jobConfig = this.getJobConfiguration(jobConfigPOJO);
        result.setTable(jobConfig.getSourceTableName());
        return result;
    }

    @Override
    public void extendYamlJobConfiguration(YamlPipelineJobConfiguration yamlJobConfig) {
        YamlMigrationJobConfiguration config = (YamlMigrationJobConfiguration)yamlJobConfig;
        if (null == yamlJobConfig.getJobId()) {
            config.setJobId(this.generateJobId(config));
        }
        if (Strings.isNullOrEmpty((String)config.getSourceDatabaseType())) {
            PipelineDataSourceConfiguration sourceDataSourceConfig = PipelineDataSourceConfigurationFactory.newInstance((String)config.getSource().getType(), (String)config.getSource().getParameter());
            config.setSourceDatabaseType(sourceDataSourceConfig.getDatabaseType().getType());
        }
        if (Strings.isNullOrEmpty((String)config.getTargetDatabaseType())) {
            PipelineDataSourceConfiguration targetDataSourceConfig = PipelineDataSourceConfigurationFactory.newInstance((String)config.getTarget().getType(), (String)config.getTarget().getParameter());
            config.setTargetDatabaseType(targetDataSourceConfig.getDatabaseType().getType());
        }
        JobDataNodeEntry nodeEntry = new JobDataNodeEntry(config.getSourceTableName(), Collections.singletonList(new DataNode(config.getSourceResourceName(), config.getSourceTableName())));
        String dataNodeLine = new JobDataNodeLine(Collections.singletonList(nodeEntry)).marshal();
        config.setTablesFirstDataNodes(dataNodeLine);
        config.setJobShardingDataNodes(Collections.singletonList(dataNodeLine));
    }

    private String generateJobId(YamlMigrationJobConfiguration config) {
        MigrationJobId jobId = new MigrationJobId(config.getSourceResourceName(), config.getSourceSchemaName(), config.getSourceTableName(), config.getTargetDatabaseName(), config.getTargetTableName());
        return this.marshalJobId(jobId);
    }

    @Override
    protected YamlPipelineJobConfiguration swapToYamlJobConfiguration(PipelineJobConfiguration jobConfig) {
        return new YamlMigrationJobConfigurationSwapper().swapToYamlConfiguration((MigrationJobConfiguration)jobConfig);
    }

    @Override
    public MigrationJobConfiguration getJobConfiguration(String jobId) {
        return this.getJobConfiguration(this.getElasticJobConfigPOJO(jobId));
    }

    protected MigrationJobConfiguration getJobConfiguration(JobConfigurationPOJO jobConfigPOJO) {
        return YamlMigrationJobConfigurationSwapper.swapToObject((String)jobConfigPOJO.getJobParameter());
    }

    @Override
    public TaskConfiguration buildTaskConfiguration(PipelineJobConfiguration pipelineJobConfig, int jobShardingItem, PipelineProcessConfiguration pipelineProcessConfig) {
        MigrationJobConfiguration jobConfig = (MigrationJobConfiguration)pipelineJobConfig;
        LinkedHashMap<ActualTableName, LogicTableName> tableNameMap = new LinkedHashMap<ActualTableName, LogicTableName>();
        tableNameMap.put(new ActualTableName(jobConfig.getSourceTableName()), new LogicTableName(jobConfig.getSourceTableName()));
        Map tableNameSchemaMap = TableNameSchemaNameMapping.convert((String)jobConfig.getSourceSchemaName(), Collections.singletonList(jobConfig.getTargetTableName()));
        TableNameSchemaNameMapping tableNameSchemaNameMapping = new TableNameSchemaNameMapping(tableNameSchemaMap);
        DumperConfiguration dumperConfig = MigrationJobAPIImpl.createDumperConfiguration(jobConfig.getJobId(), jobConfig.getSourceResourceName(), jobConfig.getSource(), tableNameMap, tableNameSchemaNameMapping);
        ImporterConfiguration importerConfig = MigrationJobAPIImpl.createImporterConfiguration(jobConfig, pipelineProcessConfig, Collections.emptyMap(), tableNameSchemaNameMapping);
        TaskConfiguration result = new TaskConfiguration(dumperConfig, importerConfig);
        log.info("createTaskConfiguration, sourceResourceName={}, result={}", (Object)jobConfig.getSourceResourceName(), (Object)result);
        return result;
    }

    private static DumperConfiguration createDumperConfiguration(String jobId, String dataSourceName, PipelineDataSourceConfiguration sourceDataSource, Map<ActualTableName, LogicTableName> tableNameMap, TableNameSchemaNameMapping tableNameSchemaNameMapping) {
        DumperConfiguration result = new DumperConfiguration();
        result.setJobId(jobId);
        result.setDataSourceName(dataSourceName);
        result.setDataSourceConfig(sourceDataSource);
        result.setTableNameMap(tableNameMap);
        result.setTableNameSchemaNameMapping(tableNameSchemaNameMapping);
        return result;
    }

    private static ImporterConfiguration createImporterConfiguration(MigrationJobConfiguration jobConfig, PipelineProcessConfiguration pipelineProcessConfig, Map<LogicTableName, Set<String>> shardingColumnsMap, TableNameSchemaNameMapping tableNameSchemaNameMapping) {
        PipelineDataSourceConfiguration dataSourceConfig = PipelineDataSourceConfigurationFactory.newInstance((String)jobConfig.getTarget().getType(), (String)jobConfig.getTarget().getParameter());
        int batchSize = pipelineProcessConfig.getWrite().getBatchSize();
        int retryTimes = jobConfig.getRetryTimes();
        int concurrency = jobConfig.getConcurrency();
        MigrationProcessContext migrationProcessContext = new MigrationProcessContext(jobConfig.getJobId(), pipelineProcessConfig);
        return new ImporterConfiguration(dataSourceConfig, MigrationJobAPIImpl.unmodifiable(shardingColumnsMap), tableNameSchemaNameMapping, batchSize, migrationProcessContext.getWriteRateLimitAlgorithm(), retryTimes, concurrency);
    }

    private static Map<LogicTableName, Set<String>> unmodifiable(Map<LogicTableName, Set<String>> shardingColumnsMap) {
        HashMap<LogicTableName, Set<String>> result = new HashMap<LogicTableName, Set<String>>(shardingColumnsMap.size());
        for (Map.Entry<LogicTableName, Set<String>> entry : shardingColumnsMap.entrySet()) {
            result.put(entry.getKey(), Collections.unmodifiableSet(entry.getValue()));
        }
        return Collections.unmodifiableMap(result);
    }

    @Override
    public MigrationProcessContext buildPipelineProcessContext(PipelineJobConfiguration pipelineJobConfig) {
        PipelineProcessConfiguration processConfig = this.showProcessConfiguration();
        return new MigrationProcessContext(pipelineJobConfig.getJobId(), processConfig);
    }

    public Map<Integer, InventoryIncrementalJobItemProgress> getJobProgress(String jobId) {
        this.checkModeConfig();
        return this.getJobProgress(this.getJobConfiguration(jobId));
    }

    @Override
    public Map<Integer, InventoryIncrementalJobItemProgress> getJobProgress(MigrationJobConfiguration jobConfig) {
        String jobId = jobConfig.getJobId();
        JobConfigurationPOJO jobConfigPOJO = this.getElasticJobConfigPOJO(jobId);
        return IntStream.range(0, jobConfig.getJobShardingCount()).boxed().collect(LinkedHashMap::new, (map, each) -> {
            InventoryIncrementalJobItemProgress jobItemProgress = this.getJobItemProgress(jobId, (int)each);
            if (null != jobItemProgress) {
                jobItemProgress.setActive(!jobConfigPOJO.isDisabled());
            }
            map.put(each, jobItemProgress);
        }, HashMap::putAll);
    }

    @Override
    public InventoryIncrementalJobItemProgress getJobItemProgress(String jobId, int shardingItem) {
        return (InventoryIncrementalJobItemProgress)this.jobItemAPI.getJobItemProgress(jobId, shardingItem);
    }

    @Override
    public void persistJobItemProgress(PipelineJobItemContext jobItemContext) {
        this.jobItemAPI.persistJobItemProgress(jobItemContext);
    }

    @Override
    public void updateJobItemStatus(String jobId, int shardingItem, JobStatus status) {
        this.jobItemAPI.updateJobItemStatus(jobId, shardingItem, status);
    }

    public Collection<DataConsistencyCheckAlgorithmInfo> listDataConsistencyCheckAlgorithms() {
        this.checkModeConfig();
        return DataConsistencyCalculateAlgorithmFactory.getAllInstances().stream().map(each -> {
            DataConsistencyCheckAlgorithmInfo result = new DataConsistencyCheckAlgorithmInfo();
            result.setType(each.getType());
            result.setDescription(each.getDescription());
            result.setSupportedDatabaseTypes(each.getSupportedDatabaseTypes());
            return result;
        }).collect(Collectors.toList());
    }

    public Map<String, DataConsistencyCheckResult> dataConsistencyCheck(String jobId) {
        this.checkModeConfig();
        log.info("Data consistency check for job {}", (Object)jobId);
        MigrationJobConfiguration jobConfig = this.getJobConfiguration(this.getElasticJobConfigPOJO(jobId));
        return this.dataConsistencyCheck(jobConfig);
    }

    @Override
    public Map<String, DataConsistencyCheckResult> dataConsistencyCheck(MigrationJobConfiguration jobConfig) {
        DataConsistencyCalculateAlgorithm algorithm = DataConsistencyCalculateAlgorithmChooser.choose(DatabaseTypeFactory.getInstance((String)jobConfig.getSourceDatabaseType()), DatabaseTypeFactory.getInstance((String)jobConfig.getTargetDatabaseType()));
        return this.dataConsistencyCheck(jobConfig, algorithm);
    }

    public Map<String, DataConsistencyCheckResult> dataConsistencyCheck(String jobId, String algorithmType, Properties algorithmProps) {
        this.checkModeConfig();
        log.info("Data consistency check for job {}, algorithmType: {}", (Object)jobId, (Object)algorithmType);
        MigrationJobConfiguration jobConfig = this.getJobConfiguration(this.getElasticJobConfigPOJO(jobId));
        return this.dataConsistencyCheck(jobConfig, DataConsistencyCalculateAlgorithmFactory.newInstance(algorithmType, algorithmProps));
    }

    private Map<String, DataConsistencyCheckResult> dataConsistencyCheck(MigrationJobConfiguration jobConfig, DataConsistencyCalculateAlgorithm calculator) {
        String jobId = jobConfig.getJobId();
        JobRateLimitAlgorithm readRateLimitAlgorithm = this.buildPipelineProcessContext((PipelineJobConfiguration)jobConfig).getReadRateLimitAlgorithm();
        Map<String, DataConsistencyCheckResult> result = new MigrationDataConsistencyChecker(jobConfig, readRateLimitAlgorithm).check(calculator);
        log.info("Scaling job {} with check algorithm '{}' data consistency checker result {}", new Object[]{jobId, calculator.getType(), result});
        PipelineAPIFactory.getGovernanceRepositoryAPI().persistJobCheckResult(jobId, this.aggregateDataConsistencyCheckResults(jobId, result));
        return result;
    }

    @Override
    public boolean aggregateDataConsistencyCheckResults(String jobId, Map<String, DataConsistencyCheckResult> checkResults) {
        if (checkResults.isEmpty()) {
            return false;
        }
        for (Map.Entry<String, DataConsistencyCheckResult> entry : checkResults.entrySet()) {
            DataConsistencyCheckResult checkResult = entry.getValue();
            boolean isCountMatched = checkResult.getCountCheckResult().isMatched();
            boolean isContentMatched = checkResult.getContentCheckResult().isMatched();
            if (isCountMatched && isContentMatched) continue;
            log.error("Scaling job: {}, table: {} data consistency check failed, count matched: {}, content matched: {}", new Object[]{jobId, entry.getKey(), isCountMatched, isContentMatched});
            return false;
        }
        return true;
    }

    @Override
    protected void cleanTempTableOnRollback(String jobId) throws SQLException {
        MigrationJobConfiguration jobConfig = this.getJobConfiguration(jobId);
        String targetTableName = jobConfig.getTargetTableName();
        String targetSchemaName = jobConfig.getSourceSchemaName();
        PipelineDataSourceConfiguration target = jobConfig.getTarget();
        PipelineSQLBuilder pipelineSQLBuilder = PipelineSQLBuilderFactory.getInstance(jobConfig.getTargetDatabaseType());
        try (PipelineDataSourceWrapper dataSource = PipelineDataSourceFactory.newInstance(PipelineDataSourceConfigurationFactory.newInstance((String)target.getType(), (String)target.getParameter()));
             Connection connection = dataSource.getConnection();){
            String sql = pipelineSQLBuilder.buildTruncateSQL(targetSchemaName, targetTableName);
            log.info("cleanTempTableOnRollback, targetSchemaName={}, targetTableName={}, sql={}", new Object[]{targetSchemaName, targetTableName, sql});
            try (PreparedStatement preparedStatement = connection.prepareStatement(sql);){
                preparedStatement.execute();
            }
        }
    }

    public void addMigrationSourceResources(Map<String, DataSourceProperties> dataSourcePropsMap) {
        log.info("Add migration source resources {}", dataSourcePropsMap.keySet());
        Object existDataSources = this.dataSourcePersistService.load(this.getJobType());
        HashSet<String> duplicateDataSourceNames = new HashSet<String>(dataSourcePropsMap.size(), 1.0f);
        for (Map.Entry<String, DataSourceProperties> entry : dataSourcePropsMap.entrySet()) {
            if (!existDataSources.containsKey(entry.getKey())) continue;
            duplicateDataSourceNames.add(entry.getKey());
        }
        if (!duplicateDataSourceNames.isEmpty()) {
            throw new AddMigrationSourceResourceException(String.format("Duplicate resource names %s.", duplicateDataSourceNames));
        }
        LinkedHashMap<String, DataSourceProperties> result = new LinkedHashMap<String, DataSourceProperties>((Map<String, DataSourceProperties>)existDataSources);
        result.putAll(dataSourcePropsMap);
        this.dataSourcePersistService.persist(this.getJobType(), (Map<String, DataSourceProperties>)result);
    }

    public void dropMigrationSourceResources(Collection<String> resourceNames) {
        Object metaDataDataSource = this.dataSourcePersistService.load(this.getJobType());
        List noExistResources = resourceNames.stream().filter(arg_0 -> MigrationJobAPIImpl.lambda$dropMigrationSourceResources$2((Map)metaDataDataSource, arg_0)).collect(Collectors.toList());
        if (!noExistResources.isEmpty()) {
            throw new DropMigrationSourceResourceException(String.format("Resource names %s not exist.", resourceNames));
        }
        for (String each : resourceNames) {
            metaDataDataSource.remove(each);
        }
        this.dataSourcePersistService.persist(this.getJobType(), (Map<String, DataSourceProperties>)metaDataDataSource);
    }

    public Collection<Collection<Object>> listMigrationSourceResources() {
        Object dataSourcePropertiesMap = this.dataSourcePersistService.load(this.getJobType());
        ArrayList<Collection<Object>> result = new ArrayList<Collection<Object>>(dataSourcePropertiesMap.size());
        for (Map.Entry entry : dataSourcePropertiesMap.entrySet()) {
            String dataSourceName = (String)entry.getKey();
            DataSourceProperties value = (DataSourceProperties)entry.getValue();
            LinkedList<Object> props = new LinkedList<Object>();
            props.add(dataSourceName);
            String url = String.valueOf(value.getConnectionPropertySynonyms().getStandardProperties().get("url"));
            DatabaseType databaseType = DatabaseTypeEngine.getDatabaseType((String)url);
            props.add(databaseType.getType());
            DataSourceMetaData metaData = databaseType.getDataSourceMetaData(url, "");
            props.add(metaData.getHostname());
            props.add(metaData.getPort());
            props.add(metaData.getCatalog());
            Map standardProps = value.getPoolPropertySynonyms().getStandardProperties();
            props.add(this.getStandardProperty(standardProps, "connectionTimeoutMilliseconds"));
            props.add(this.getStandardProperty(standardProps, "idleTimeoutMilliseconds"));
            props.add(this.getStandardProperty(standardProps, "maxLifetimeMilliseconds"));
            props.add(this.getStandardProperty(standardProps, "maxPoolSize"));
            props.add(this.getStandardProperty(standardProps, "minPoolSize"));
            props.add(this.getStandardProperty(standardProps, "readOnly"));
            Map otherProps = value.getCustomDataSourceProperties().getProperties();
            props.add(otherProps.isEmpty() ? "" : new Gson().toJson((Object)otherProps));
            result.add(props);
        }
        return result;
    }

    private String getStandardProperty(Map<String, Object> standardProps, String key) {
        if (standardProps.containsKey(key) && null != standardProps.get(key)) {
            return standardProps.get(key).toString();
        }
        return "";
    }

    public String createJobAndStart(CreateMigrationJobParameter parameter) {
        YamlMigrationJobConfiguration result = new YamlMigrationJobConfiguration();
        Object metaDataDataSource = this.dataSourcePersistService.load(JobType.MIGRATION);
        Map sourceDataSourceProps = DATA_SOURCE_CONFIG_SWAPPER.swapToMap((DataSourceProperties)metaDataDataSource.get(parameter.getSourceResourceName()));
        YamlPipelineDataSourceConfiguration sourcePipelineDataSourceConfiguration = this.createYamlPipelineDataSourceConfiguration("JDBC", YamlEngine.marshal((Object)sourceDataSourceProps));
        result.setSource(sourcePipelineDataSourceConfiguration);
        result.setSourceResourceName(parameter.getSourceResourceName());
        StandardPipelineDataSourceConfiguration sourceDataSourceConfig = new StandardPipelineDataSourceConfiguration(sourceDataSourceProps);
        DatabaseType sourceDatabaseType = sourceDataSourceConfig.getDatabaseType();
        result.setSourceDatabaseType(sourceDatabaseType.getType());
        if (null == parameter.getSourceSchemaName() && sourceDatabaseType.isSchemaAvailable()) {
            result.setSourceSchemaName(PipelineSchemaTableUtil.getDefaultSchema((PipelineDataSourceConfiguration)sourceDataSourceConfig));
        } else {
            result.setSourceSchemaName(parameter.getSourceSchemaName());
        }
        result.setSourceTableName(parameter.getSourceTableName());
        HashMap<String, Map<String, Object>> targetDataSourceProperties = new HashMap<String, Map<String, Object>>();
        ShardingSphereDatabase targetDatabase = PipelineContext.getContextManager().getMetaDataContexts().getMetaData().getDatabase(parameter.getTargetDatabaseName());
        for (Map.Entry entry : targetDatabase.getResource().getDataSources().entrySet()) {
            Map dataSourceProps = DATA_SOURCE_CONFIG_SWAPPER.swapToMap(DataSourcePropertiesCreator.create((DataSource)((DataSource)entry.getValue())));
            targetDataSourceProperties.put((String)entry.getKey(), dataSourceProps);
        }
        String targetDatabaseName = parameter.getTargetDatabaseName();
        YamlRootConfiguration targetRootConfig = this.getYamlRootConfiguration(targetDatabaseName, targetDataSourceProperties, targetDatabase.getRuleMetaData().getConfigurations());
        ShardingSpherePipelineDataSourceConfiguration targetPipelineDataSource = new ShardingSpherePipelineDataSourceConfiguration(targetRootConfig);
        result.setTarget(this.createYamlPipelineDataSourceConfiguration(targetPipelineDataSource.getType(), YamlEngine.marshal((Object)targetPipelineDataSource.getDataSourceConfiguration())));
        result.setTargetDatabaseType(targetPipelineDataSource.getDatabaseType().getType());
        result.setTargetDatabaseName(targetDatabaseName);
        result.setTargetTableName(parameter.getTargetTableName());
        this.extendYamlJobConfiguration((YamlPipelineJobConfiguration)result);
        MigrationJobConfiguration jobConfiguration = new YamlMigrationJobConfigurationSwapper().swapToObject(result);
        this.start((PipelineJobConfiguration)jobConfiguration);
        return jobConfiguration.getJobId();
    }

    private YamlRootConfiguration getYamlRootConfiguration(String databaseName, Map<String, Map<String, Object>> yamlDataSources, Collection<RuleConfiguration> rules) {
        YamlRootConfiguration result = new YamlRootConfiguration();
        result.setDatabaseName(databaseName);
        result.setDataSources(yamlDataSources);
        Collection yamlRuleConfigurations = RULE_CONFIG_SWAPPER_ENGINE.swapToYamlRuleConfigurations(rules);
        result.setRules(yamlRuleConfigurations);
        return result;
    }

    private YamlPipelineDataSourceConfiguration createYamlPipelineDataSourceConfiguration(String type, String parameter) {
        YamlPipelineDataSourceConfiguration result = new YamlPipelineDataSourceConfiguration();
        result.setType(type);
        result.setParameter(parameter);
        return result;
    }

    private static /* synthetic */ boolean lambda$dropMigrationSourceResources$2(Map metaDataDataSource, String each) {
        return !metaDataDataSource.containsKey(each);
    }
}

