/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.scenario.migration;

import java.sql.SQLException;
import lombok.Generated;
import org.apache.shardingsphere.data.pipeline.api.config.TaskConfiguration;
import org.apache.shardingsphere.data.pipeline.api.config.job.MigrationJobConfiguration;
import org.apache.shardingsphere.data.pipeline.api.config.job.PipelineJobConfiguration;
import org.apache.shardingsphere.data.pipeline.api.config.job.yaml.YamlMigrationJobConfigurationSwapper;
import org.apache.shardingsphere.data.pipeline.api.datasource.PipelineDataSourceManager;
import org.apache.shardingsphere.data.pipeline.api.job.JobStatus;
import org.apache.shardingsphere.data.pipeline.api.job.PipelineJob;
import org.apache.shardingsphere.data.pipeline.api.job.progress.InventoryIncrementalJobItemProgress;
import org.apache.shardingsphere.data.pipeline.api.task.PipelineTasksRunner;
import org.apache.shardingsphere.data.pipeline.core.datasource.DefaultPipelineDataSourceManager;
import org.apache.shardingsphere.data.pipeline.core.exception.PipelineIgnoredException;
import org.apache.shardingsphere.data.pipeline.core.job.AbstractPipelineJob;
import org.apache.shardingsphere.data.pipeline.core.job.PipelineJobCenter;
import org.apache.shardingsphere.data.pipeline.core.job.progress.persist.PipelineJobProgressPersistService;
import org.apache.shardingsphere.data.pipeline.core.metadata.node.PipelineMetaDataNode;
import org.apache.shardingsphere.data.pipeline.core.task.InventoryIncrementalTasksRunner;
import org.apache.shardingsphere.data.pipeline.core.util.PipelineDistributedBarrier;
import org.apache.shardingsphere.data.pipeline.scenario.migration.MigrationJobAPI;
import org.apache.shardingsphere.data.pipeline.scenario.migration.MigrationJobAPIFactory;
import org.apache.shardingsphere.data.pipeline.scenario.migration.MigrationJobItemContext;
import org.apache.shardingsphere.data.pipeline.scenario.migration.MigrationJobPreparer;
import org.apache.shardingsphere.data.pipeline.scenario.migration.MigrationProcessContext;
import org.apache.shardingsphere.elasticjob.api.ShardingContext;
import org.apache.shardingsphere.elasticjob.simple.job.SimpleJob;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MigrationJob
extends AbstractPipelineJob
implements SimpleJob,
PipelineJob {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MigrationJob.class);
    private final MigrationJobAPI jobAPI = MigrationJobAPIFactory.getInstance();
    private final PipelineDataSourceManager dataSourceManager = new DefaultPipelineDataSourceManager();
    private final PipelineDistributedBarrier pipelineDistributedBarrier = PipelineDistributedBarrier.getInstance();
    private final MigrationJobPreparer jobPreparer = new MigrationJobPreparer();

    public void execute(ShardingContext shardingContext) {
        int shardingItem = shardingContext.getShardingItem();
        log.info("Execute job {}-{}", (Object)shardingContext.getJobName(), (Object)shardingItem);
        if (this.isStopping()) {
            log.info("stopping true, ignore");
            return;
        }
        this.setJobId(shardingContext.getJobName());
        MigrationJobConfiguration jobConfig = YamlMigrationJobConfigurationSwapper.swapToObject((String)shardingContext.getJobParameter());
        InventoryIncrementalJobItemProgress initProgress = this.jobAPI.getJobItemProgress(shardingContext.getJobName(), shardingItem);
        MigrationProcessContext jobProcessContext = this.jobAPI.buildPipelineProcessContext((PipelineJobConfiguration)jobConfig);
        TaskConfiguration taskConfig = this.jobAPI.buildTaskConfiguration((PipelineJobConfiguration)jobConfig, shardingItem, jobProcessContext.getPipelineProcessConfig());
        MigrationJobItemContext jobItemContext = new MigrationJobItemContext(jobConfig, shardingItem, initProgress, jobProcessContext, taskConfig, this.dataSourceManager);
        if (this.getTasksRunnerMap().containsKey(shardingItem)) {
            log.warn("tasksRunnerMap contains shardingItem {}, ignore", (Object)shardingItem);
            return;
        }
        log.info("start tasks runner, jobId={}, shardingItem={}", (Object)this.getJobId(), (Object)shardingItem);
        InventoryIncrementalTasksRunner tasksRunner = new InventoryIncrementalTasksRunner(jobItemContext, jobItemContext.getInventoryTasks(), jobItemContext.getIncrementalTasks(), jobItemContext.getJobProcessContext().getInventoryDumperExecuteEngine(), jobItemContext.getJobProcessContext().getIncrementalDumperExecuteEngine());
        this.runInBackground(() -> {
            this.prepare(jobItemContext);
            tasksRunner.start();
        });
        this.getTasksRunnerMap().put(shardingItem, tasksRunner);
        PipelineJobProgressPersistService.addJobProgressPersistContext(this.getJobId(), shardingItem);
        this.pipelineDistributedBarrier.persistEphemeralChildrenNode(PipelineMetaDataNode.getJobBarrierEnablePath(this.getJobId()), shardingItem);
    }

    private void prepare(MigrationJobItemContext jobItemContext) {
        try {
            this.jobPreparer.prepare(jobItemContext);
        }
        catch (PipelineIgnoredException ex) {
            log.info("pipeline ignore exception: {}", (Object)ex.getMessage());
            PipelineJobCenter.stop(this.getJobId());
        }
        catch (RuntimeException | SQLException ex) {
            log.error("job prepare failed, {}-{}", new Object[]{this.getJobId(), jobItemContext.getShardingItem(), ex});
            PipelineJobCenter.stop(this.getJobId());
            jobItemContext.setStatus(JobStatus.PREPARING_FAILURE);
            this.jobAPI.persistJobItemProgress(jobItemContext);
            if (ex instanceof RuntimeException) {
                throw (RuntimeException)ex;
            }
            throw new RuntimeException(ex);
        }
    }

    public void stop() {
        this.setStopping(true);
        this.dataSourceManager.close();
        if (null != this.getOneOffJobBootstrap()) {
            this.getOneOffJobBootstrap().shutdown();
        }
        if (null == this.getJobId()) {
            log.info("stop, jobId is null, ignore");
            return;
        }
        log.info("stop tasks runner, jobId={}", (Object)this.getJobId());
        String scalingJobBarrierDisablePath = PipelineMetaDataNode.getJobBarrierDisablePath(this.getJobId());
        for (PipelineTasksRunner each : this.getTasksRunnerMap().values()) {
            each.stop();
            this.pipelineDistributedBarrier.persistEphemeralChildrenNode(scalingJobBarrierDisablePath, each.getJobItemContext().getShardingItem());
        }
        this.getTasksRunnerMap().clear();
        PipelineJobProgressPersistService.removeJobProgressPersistContext(this.getJobId());
    }

    @Generated
    public MigrationJob() {
    }
}

