/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.core.util;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import lombok.Generated;

public final class ReflectionUtil {
    public static void setFieldValue(Object target, String fieldName, Object value) throws NoSuchFieldException, IllegalAccessException {
        Field field = ReflectionUtil.getField(target.getClass(), fieldName, true);
        field.set(target, value);
    }

    public static <T> T getFieldValue(Object target, String fieldName, Class<T> valueClass) throws NoSuchFieldException, IllegalAccessException {
        Field field = ReflectionUtil.getField(target.getClass(), fieldName, true);
        Object value = field.get(target);
        if (null == value) {
            return null;
        }
        if (valueClass.isAssignableFrom(value.getClass())) {
            return (T)value;
        }
        throw new ClassCastException("field " + fieldName + " is " + value.getClass().getName() + " can cast to " + valueClass.getName());
    }

    private static Field getField(Class<?> targetClass, String fieldName, boolean isDeclared) throws NoSuchFieldException {
        Field result = isDeclared ? targetClass.getDeclaredField(fieldName) : targetClass.getField(fieldName);
        result.setAccessible(true);
        return result;
    }

    public static Object invokeMethod(Object target, String methodName, Class<?>[] parameterTypes, Object[] parameterValues) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        Method method = target.getClass().getDeclaredMethod(methodName, parameterTypes);
        method.setAccessible(true);
        return method.invoke(target, parameterValues);
    }

    @Generated
    private ReflectionUtil() {
    }
}

