/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.core.util;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.shardingsphere.data.pipeline.api.datasource.PipelineDataSourceWrapper;
import org.apache.shardingsphere.data.pipeline.api.datasource.config.PipelineDataSourceConfiguration;
import org.apache.shardingsphere.data.pipeline.core.datasource.PipelineDataSourceFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PipelineSchemaTableUtil {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PipelineSchemaTableUtil.class);

    private PipelineSchemaTableUtil() {
    }

    public static Map<String, List<String>> getSchemaTablesMapFromActual(PipelineDataSourceConfiguration pipelineDataSourceConfig, String schemaName, String tableName) {
        log.info("start get schema tables from actual, begin:{}", (Object)LocalDateTime.now());
        HashMap<String, List<String>> result = new HashMap<String, List<String>>();
        try (PipelineDataSourceWrapper dataSource = PipelineDataSourceFactory.newInstance(pipelineDataSourceConfig);
             Connection connection = dataSource.getConnection();){
            DatabaseMetaData metaData = connection.getMetaData();
            String targetSchema = (String)ObjectUtils.defaultIfNull((Object)schemaName, (Object)connection.getSchema());
            ResultSet resultSet = metaData.getTables(connection.getCatalog(), targetSchema, tableName, new String[]{"TABLE"});
            while (resultSet.next()) {
                result.computeIfAbsent(targetSchema, k -> new ArrayList()).add(resultSet.getString("TABLE_NAME"));
            }
            log.info("get schema tables success, catalog:{}, schema:{}, table:{}, result:{}, end:{}", new Object[]{targetSchema, connection.getCatalog(), tableName, resultSet, LocalDateTime.now()});
        }
        catch (SQLException ex) {
            log.error("get schema name map error", (Throwable)ex);
            throw new RuntimeException(ex.getMessage());
        }
        return result;
    }

    /*
     * Exception decompiling
     */
    public static String getDefaultSchema(PipelineDataSourceConfiguration dataSourceConfig) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

