/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.core.util;

import com.google.common.base.Splitter;
import java.util.List;
import java.util.Properties;
import java.util.regex.Pattern;
import org.apache.shardingsphere.infra.config.rule.data.pipeline.PipelineProcessConfiguration;
import org.apache.shardingsphere.infra.yaml.config.pojo.algorithm.YamlAlgorithmConfiguration;
import org.apache.shardingsphere.infra.yaml.config.pojo.data.pipeline.YamlPipelineProcessConfiguration;
import org.apache.shardingsphere.infra.yaml.config.pojo.data.pipeline.YamlPipelineReadConfiguration;
import org.apache.shardingsphere.infra.yaml.config.pojo.data.pipeline.YamlPipelineWriteConfiguration;
import org.apache.shardingsphere.infra.yaml.config.swapper.rule.data.pipeline.YamlPipelineProcessConfigurationSwapper;

public final class PipelineProcessConfigurationUtils {
    private static final YamlPipelineProcessConfigurationSwapper SWAPPER = new YamlPipelineProcessConfigurationSwapper();
    private static final String CONF_PATH_REGEX = "^/|(/[a-zA-Z_]+)+$";
    private static final Pattern CONF_PATH_PATTERN = Pattern.compile("^/|(/[a-zA-Z_]+)+$");

    public static PipelineProcessConfiguration convertWithDefaultValue(PipelineProcessConfiguration originalConfig) {
        YamlPipelineProcessConfiguration yamlConfig = null != originalConfig ? SWAPPER.swapToYamlConfiguration(originalConfig) : new YamlPipelineProcessConfiguration();
        PipelineProcessConfigurationUtils.fillInDefaultValue(yamlConfig);
        return SWAPPER.swapToObject(yamlConfig);
    }

    public static void fillInDefaultValue(YamlPipelineProcessConfiguration yamlConfig) {
        if (null == yamlConfig.getRead()) {
            yamlConfig.setRead(YamlPipelineReadConfiguration.buildWithDefaultValue());
        } else {
            yamlConfig.getRead().fillInNullFieldsWithDefaultValue();
        }
        if (null == yamlConfig.getWrite()) {
            yamlConfig.setWrite(YamlPipelineWriteConfiguration.buildWithDefaultValue());
        } else {
            yamlConfig.getWrite().fillInNullFieldsWithDefaultValue();
        }
        if (null == yamlConfig.getStreamChannel()) {
            Properties props = new Properties();
            props.put("block-queue-size", (Object)10000);
            yamlConfig.setStreamChannel(new YamlAlgorithmConfiguration("MEMORY", props));
        }
    }

    public static void verifyConfPath(String confPath) {
        if (!CONF_PATH_PATTERN.matcher(confPath).matches()) {
            throw new IllegalArgumentException("Invalid confPath, it doesn't match pattern: ^/|(/[a-zA-Z_]+)+$");
        }
    }

    public static void setFieldsNullByConfPath(YamlPipelineProcessConfiguration targetYamlProcessConfig, String confPath) {
        List confPathNodes = Splitter.on((char)'/').splitToList((CharSequence)confPath);
        if (2 == confPathNodes.size()) {
            String levelOne = ((String)confPathNodes.get(1)).toUpperCase();
            if (levelOne.isEmpty()) {
                targetYamlProcessConfig.setAllFieldsNull();
            } else {
                targetYamlProcessConfig.setFieldNull(levelOne);
            }
        } else if (3 == confPathNodes.size()) {
            String levelOne = ((String)confPathNodes.get(1)).toUpperCase();
            String levelTwo = ((String)confPathNodes.get(2)).toUpperCase();
            if ("READ".equals(levelOne) && null != targetYamlProcessConfig.getRead()) {
                targetYamlProcessConfig.getRead().setFieldNull(levelTwo);
            } else if ("WRITE".equals(levelOne) && null != targetYamlProcessConfig.getWrite()) {
                targetYamlProcessConfig.getWrite().setFieldNull(levelTwo);
            }
        }
    }
}

