/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.core.util;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.concurrent.LazyInitializer;
import org.apache.shardingsphere.data.pipeline.core.context.PipelineContext;
import org.apache.shardingsphere.mode.repository.cluster.ClusterPersistRepository;
import org.apache.shardingsphere.mode.repository.cluster.listener.DataChangedEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PipelineDistributedBarrier {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PipelineDistributedBarrier.class);
    private static final PipelineDistributedBarrier INSTANCE = new PipelineDistributedBarrier();
    private static final LazyInitializer<ClusterPersistRepository> REPOSITORY_LAZY_INITIALIZER = new LazyInitializer<ClusterPersistRepository>(){

        protected ClusterPersistRepository initialize() {
            return (ClusterPersistRepository)PipelineContext.getContextManager().getMetaDataContexts().getPersistService().getRepository();
        }
    };
    private final Map<String, InnerCountDownLatchHolder> countDownLatchMap = new ConcurrentHashMap<String, InnerCountDownLatchHolder>();

    private static ClusterPersistRepository getRepository() {
        return (ClusterPersistRepository)REPOSITORY_LAZY_INITIALIZER.get();
    }

    public static PipelineDistributedBarrier getInstance() {
        return INSTANCE;
    }

    public void register(String parentPath, int totalCount) {
        PipelineDistributedBarrier.getRepository().persist(parentPath, "");
        this.countDownLatchMap.computeIfAbsent(parentPath, k -> new InnerCountDownLatchHolder(totalCount, new CountDownLatch(1)));
    }

    public void persistEphemeralChildrenNode(String parentPath, int shardingItem) {
        String key = String.join((CharSequence)"/", parentPath, Integer.toString(shardingItem));
        PipelineDistributedBarrier.getRepository().delete(key);
        PipelineDistributedBarrier.getRepository().persistEphemeral(key, "");
    }

    public void removeParentNode(String parentPath) {
        PipelineDistributedBarrier.getRepository().delete(String.join((CharSequence)"/", parentPath));
        InnerCountDownLatchHolder holder = this.countDownLatchMap.remove(parentPath);
        if (null != holder) {
            holder.getCountDownLatch().countDown();
        }
    }

    public boolean await(String parentPath, long timeout, TimeUnit timeUnit) {
        InnerCountDownLatchHolder holder = this.countDownLatchMap.get(parentPath);
        if (null == holder) {
            return false;
        }
        try {
            boolean result = holder.getCountDownLatch().await(timeout, timeUnit);
            if (!result) {
                log.info("await timeout, parent path: {}, timeout: {}, time unit: {}", new Object[]{parentPath, timeout, timeUnit});
            }
            return result;
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
    }

    public void checkChildrenNodeCount(DataChangedEvent event) {
        if (StringUtils.isBlank((CharSequence)event.getKey())) {
            return;
        }
        String parentPath = event.getKey().substring(0, event.getKey().lastIndexOf("/"));
        InnerCountDownLatchHolder holder = this.countDownLatchMap.get(parentPath);
        if (null == holder) {
            return;
        }
        List childrenKeys = PipelineDistributedBarrier.getRepository().getChildrenKeys(parentPath);
        log.info("children keys: {}, total count: {}", (Object)childrenKeys, (Object)holder.getTotalCount());
        if (childrenKeys.size() == holder.getTotalCount()) {
            holder.getCountDownLatch().countDown();
        }
    }

    private static class InnerCountDownLatchHolder {
        private final int totalCount;
        private final CountDownLatch countDownLatch;

        @Generated
        public InnerCountDownLatchHolder(int totalCount, CountDownLatch countDownLatch) {
            this.totalCount = totalCount;
            this.countDownLatch = countDownLatch;
        }

        @Generated
        public int getTotalCount() {
            return this.totalCount;
        }

        @Generated
        public CountDownLatch getCountDownLatch() {
            return this.countDownLatch;
        }
    }
}

