/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.core.sqlbuilder;

import java.util.Map;
import java.util.Set;
import lombok.NonNull;
import org.apache.shardingsphere.data.pipeline.api.ingest.record.DataRecord;
import org.apache.shardingsphere.data.pipeline.api.metadata.LogicTableName;
import org.apache.shardingsphere.data.pipeline.core.sqlbuilder.AbstractPipelineSQLBuilder;
import org.apache.shardingsphere.data.pipeline.core.util.PipelineJdbcUtils;

public final class OraclePipelineSQLBuilder
extends AbstractPipelineSQLBuilder {
    public String buildCreateSchemaSQL(String schemaName) {
        throw new UnsupportedOperationException("Not supported for now");
    }

    @Override
    public String getLeftIdentifierQuoteString() {
        return "\"";
    }

    @Override
    public String getRightIdentifierQuoteString() {
        return "\"";
    }

    @Override
    public String buildInventoryDumpSQL(String schemaName, String tableName, String uniqueKey, int uniqueKeyDataType, boolean firstQuery) {
        String decoratedTableName = this.decorate(schemaName, tableName);
        String quotedUniqueKey = this.quote(uniqueKey);
        if (PipelineJdbcUtils.isIntegerColumn(uniqueKeyDataType)) {
            return "SELECT * FROM (SELECT * FROM " + decoratedTableName + " WHERE " + quotedUniqueKey + " " + (firstQuery ? ">=" : ">") + " ? AND " + quotedUniqueKey + " <= ? ORDER BY " + quotedUniqueKey + " ASC) WHERE ROWNUM<=?";
        }
        if (PipelineJdbcUtils.isStringColumn(uniqueKeyDataType)) {
            return "SELECT * FROM (SELECT * FROM " + decoratedTableName + " WHERE " + quotedUniqueKey + " " + (firstQuery ? ">=" : ">") + " ? ORDER BY " + quotedUniqueKey + " ASC) WHERE ROWNUM<=?";
        }
        throw new IllegalArgumentException("Unknown uniqueKeyDataType: " + uniqueKeyDataType);
    }

    @Override
    public String buildInsertSQL(String schemaName, DataRecord dataRecord, Map<LogicTableName, Set<String>> shardingColumnsMap) {
        return super.buildInsertSQL(schemaName, dataRecord, shardingColumnsMap);
    }

    @Override
    public String buildChunkedQuerySQL(String schemaName, @NonNull String tableName, @NonNull String uniqueKey, boolean firstQuery) {
        if (tableName == null) {
            throw new NullPointerException("tableName is marked non-null but is null");
        }
        if (uniqueKey == null) {
            throw new NullPointerException("uniqueKey is marked non-null but is null");
        }
        if (firstQuery) {
            return "SELECT * FROM (SELECT * FROM " + this.decorate(schemaName, tableName) + " ORDER BY " + this.quote(uniqueKey) + " ASC) WHERE ROWNUM<=?";
        }
        return "SELECT * FROM (SELECT * FROM " + this.decorate(schemaName, tableName) + " WHERE " + this.quote(uniqueKey) + " > ? ORDER BY " + this.quote(uniqueKey) + " ASC) WHERE ROWNUM<=?";
    }

    @Override
    public String buildCheckEmptySQL(String schemaName, String tableName) {
        return String.format("SELECT * FROM (SELECT * FROM %s) WHERE ROWNUM<=1", this.decorate(schemaName, tableName));
    }

    @Override
    public String buildSplitByPrimaryKeyRangeSQL(String schemaName, String tableName, String primaryKey) {
        String quotedKey = this.quote(primaryKey);
        return String.format("SELECT MAX(%s) FROM (SELECT * FROM (SELECT %s FROM %s WHERE %s>=? ORDER BY %s) WHERE ROWNUM<=?) t", quotedKey, quotedKey, this.decorate(schemaName, tableName), quotedKey, quotedKey);
    }

    public String getType() {
        return "Oracle";
    }
}

