/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.core.spi.ratelimit;

import com.google.common.base.Strings;
import com.google.common.util.concurrent.RateLimiter;
import java.util.Properties;
import lombok.Generated;
import org.apache.shardingsphere.data.pipeline.api.job.JobOperationType;
import org.apache.shardingsphere.data.pipeline.spi.ratelimit.JobRateLimitAlgorithm;

public final class TPSJobRateLimitAlgorithm
implements JobRateLimitAlgorithm {
    private static final String TPS_KEY = "tps";
    private int tps = 2000;
    private RateLimiter rateLimiter;
    private Properties props = new Properties();

    public void init(Properties props) {
        this.props = props;
        String tpsValue = props.getProperty(TPS_KEY);
        if (!Strings.isNullOrEmpty((String)tpsValue)) {
            this.tps = Integer.parseInt(tpsValue);
        }
        this.rateLimiter = RateLimiter.create((double)this.tps);
    }

    public String getType() {
        return "TPS";
    }

    public void intercept(JobOperationType type, Number data) {
        switch (type) {
            case INSERT: 
            case DELETE: 
            case UPDATE: {
                this.rateLimiter.acquire(null != data ? data.intValue() : 1);
                break;
            }
        }
    }

    public String toString() {
        return "TPSJobRateLimitAlgorithm{props=" + this.props + '}';
    }

    @Generated
    public Properties getProps() {
        return this.props;
    }
}

