/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.core.registry;

import java.util.Properties;
import org.apache.shardingsphere.elasticjob.reg.base.CoordinatorRegistryCenter;
import org.apache.shardingsphere.elasticjob.reg.zookeeper.ZookeeperConfiguration;
import org.apache.shardingsphere.elasticjob.reg.zookeeper.ZookeeperRegistryCenter;
import org.apache.shardingsphere.infra.config.mode.ModeConfiguration;
import org.apache.shardingsphere.mode.repository.cluster.ClusterPersistRepositoryConfiguration;
import org.apache.shardingsphere.mode.repository.cluster.zookeeper.props.ZookeeperProperties;
import org.apache.shardingsphere.mode.repository.cluster.zookeeper.props.ZookeeperPropertyKey;

public final class CoordinatorRegistryCenterInitializer {
    public CoordinatorRegistryCenter createRegistryCenter(ModeConfiguration modeConfig, String namespaceRelativePath) {
        ClusterPersistRepositoryConfiguration repositoryConfig = (ClusterPersistRepositoryConfiguration)modeConfig.getRepository();
        String clusterType = modeConfig.getRepository().getType();
        if ("ZooKeeper".equalsIgnoreCase(clusterType)) {
            ZookeeperRegistryCenter result = new ZookeeperRegistryCenter(this.getZookeeperConfig(repositoryConfig, namespaceRelativePath));
            result.init();
            return result;
        }
        throw new IllegalArgumentException("Unsupported clusterType=" + clusterType);
    }

    private ZookeeperConfiguration getZookeeperConfig(ClusterPersistRepositoryConfiguration repositoryConfig, String namespaceRelativePath) {
        int operationTimeoutMilliseconds;
        Properties props = repositoryConfig.getProps();
        ZookeeperProperties zookeeperProps = new ZookeeperProperties(props);
        String namespace = repositoryConfig.getNamespace() + (null != namespaceRelativePath ? namespaceRelativePath : "");
        ZookeeperConfiguration result = new ZookeeperConfiguration(repositoryConfig.getServerLists(), namespace);
        int retryIntervalMilliseconds = (Integer)zookeeperProps.getValue((Enum)ZookeeperPropertyKey.RETRY_INTERVAL_MILLISECONDS);
        result.setBaseSleepTimeMilliseconds(retryIntervalMilliseconds);
        int maxRetries = (Integer)zookeeperProps.getValue((Enum)ZookeeperPropertyKey.MAX_RETRIES);
        result.setMaxRetries(maxRetries);
        result.setMaxSleepTimeMilliseconds(retryIntervalMilliseconds * maxRetries);
        int timeToLiveSeconds = (Integer)zookeeperProps.getValue((Enum)ZookeeperPropertyKey.TIME_TO_LIVE_SECONDS);
        if (0 != timeToLiveSeconds) {
            result.setSessionTimeoutMilliseconds(timeToLiveSeconds * 1000);
        }
        if (0 != (operationTimeoutMilliseconds = ((Integer)zookeeperProps.getValue((Enum)ZookeeperPropertyKey.OPERATION_TIMEOUT_MILLISECONDS)).intValue())) {
            result.setConnectionTimeoutMilliseconds(operationTimeoutMilliseconds);
        }
        String digest = (String)zookeeperProps.getValue((Enum)ZookeeperPropertyKey.DIGEST);
        result.setDigest(digest);
        return result;
    }
}

