/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.core.prepare.datasource;

import com.google.common.base.Preconditions;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import javax.sql.DataSource;
import lombok.Generated;
import org.apache.shardingsphere.data.pipeline.api.config.job.MigrationJobConfiguration;
import org.apache.shardingsphere.data.pipeline.api.datanode.JobDataNodeEntry;
import org.apache.shardingsphere.data.pipeline.api.datasource.PipelineDataSourceManager;
import org.apache.shardingsphere.data.pipeline.api.datasource.PipelineDataSourceWrapper;
import org.apache.shardingsphere.data.pipeline.api.datasource.config.PipelineDataSourceConfiguration;
import org.apache.shardingsphere.data.pipeline.api.datasource.config.PipelineDataSourceConfigurationFactory;
import org.apache.shardingsphere.data.pipeline.core.exception.PipelineJobPrepareFailedException;
import org.apache.shardingsphere.data.pipeline.core.metadata.generator.PipelineDDLGenerator;
import org.apache.shardingsphere.data.pipeline.core.prepare.datasource.DataSourcePreparer;
import org.apache.shardingsphere.data.pipeline.core.prepare.datasource.PrepareTargetSchemasParameter;
import org.apache.shardingsphere.data.pipeline.core.prepare.datasource.PrepareTargetTablesParameter;
import org.apache.shardingsphere.data.pipeline.core.sqlbuilder.PipelineSQLBuilderFactory;
import org.apache.shardingsphere.data.pipeline.spi.sqlbuilder.PipelineSQLBuilder;
import org.apache.shardingsphere.infra.database.type.DatabaseType;
import org.apache.shardingsphere.infra.database.type.DatabaseTypeEngine;
import org.apache.shardingsphere.infra.datanode.DataNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDataSourcePreparer
implements DataSourcePreparer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractDataSourcePreparer.class);
    private static final Pattern PATTERN_CREATE_TABLE_IF_NOT_EXISTS = Pattern.compile("CREATE\\s+TABLE\\s+IF\\s+NOT\\s+EXISTS\\s+", 2);
    private static final Pattern PATTERN_CREATE_TABLE = Pattern.compile("CREATE\\s+TABLE\\s+", 2);
    private static final String[] IGNORE_EXCEPTION_MESSAGE = new String[]{"multiple primary keys for table", "already exists"};

    @Override
    public void prepareTargetSchemas(PrepareTargetSchemasParameter parameter) {
        Set<String> schemaNames = this.getSchemaNames(parameter);
        String defaultSchema = DatabaseTypeEngine.getDefaultSchemaName((DatabaseType)parameter.getTargetDatabaseType(), (String)parameter.getDatabaseName());
        log.info("prepareTargetSchemas, schemaNames={}, defaultSchema={}", schemaNames, (Object)defaultSchema);
        PipelineSQLBuilder pipelineSQLBuilder = PipelineSQLBuilderFactory.getInstance(parameter.getTargetDatabaseType().getType());
        try (Connection targetConnection = this.getCachedDataSource(parameter.getDataSourceConfig(), parameter.getDataSourceManager()).getConnection();){
            for (String each : schemaNames) {
                if (each.equalsIgnoreCase(defaultSchema)) continue;
                String sql = pipelineSQLBuilder.buildCreateSchemaSQL(each);
                log.info("prepareTargetSchemas, sql={}", (Object)sql);
                try {
                    Statement statement = targetConnection.createStatement();
                    Throwable throwable = null;
                    try {
                        statement.execute(sql);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (statement == null) continue;
                        if (throwable != null) {
                            try {
                                statement.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        statement.close();
                    }
                }
                catch (SQLException sQLException) {}
            }
        }
        catch (SQLException ex) {
            throw new PipelineJobPrepareFailedException("Can not get connection.", ex);
        }
    }

    private Set<String> getSchemaNames(PrepareTargetSchemasParameter parameter) {
        HashSet<String> result = new HashSet<String>();
        for (String each : parameter.getLogicTableNames()) {
            String schemaName = parameter.getTableNameSchemaNameMapping().getSchemaName(each);
            if (null == schemaName) {
                throw new PipelineJobPrepareFailedException("Can not get schemaName by logic table name " + each);
            }
            result.add(schemaName);
        }
        return result;
    }

    protected final PipelineDataSourceWrapper getSourceCachedDataSource(MigrationJobConfiguration jobConfig, PipelineDataSourceManager dataSourceManager) {
        return dataSourceManager.getDataSource(PipelineDataSourceConfigurationFactory.newInstance((String)jobConfig.getSource().getType(), (String)jobConfig.getSource().getParameter()));
    }

    protected final PipelineDataSourceWrapper getCachedDataSource(PipelineDataSourceConfiguration dataSourceConfig, PipelineDataSourceManager dataSourceManager) {
        return dataSourceManager.getDataSource(dataSourceConfig);
    }

    protected final void executeTargetTableSQL(Connection targetConnection, String sql) throws SQLException {
        log.info("execute target table sql: {}", (Object)sql);
        try (Statement statement = targetConnection.createStatement();){
            statement.execute(sql);
        }
        catch (SQLException ex) {
            log.warn("execute target table sql failed", (Throwable)ex);
            for (String ignoreMessage : IGNORE_EXCEPTION_MESSAGE) {
                if (!ex.getMessage().contains(ignoreMessage)) continue;
                return;
            }
            throw ex;
        }
    }

    protected final String addIfNotExistsForCreateTableSQL(String createTableSQL) {
        if (PATTERN_CREATE_TABLE_IF_NOT_EXISTS.matcher(createTableSQL).find()) {
            return createTableSQL;
        }
        return PATTERN_CREATE_TABLE.matcher(createTableSQL).replaceFirst("CREATE TABLE IF NOT EXISTS ");
    }

    protected final List<String> listCreateLogicalTableSQL(PrepareTargetTablesParameter parameter) throws SQLException {
        PipelineDDLGenerator generator = new PipelineDDLGenerator();
        LinkedList<String> result = new LinkedList<String>();
        for (JobDataNodeEntry each : parameter.getTablesFirstDataNodes().getEntries()) {
            String dataSourceName = ((DataNode)each.getDataNodes().get(0)).getDataSourceName();
            DataSource dataSource = parameter.getSourceDataSourceMap().get(dataSourceName);
            DatabaseType databaseType = DatabaseTypeEngine.getDatabaseType(Collections.singletonList(dataSource));
            String schemaName = parameter.getTableNameSchemaNameMapping().getSchemaName(each.getLogicTableName());
            String actualTableName = ((DataNode)each.getDataNodes().get(0)).getTableName();
            Preconditions.checkNotNull((Object)actualTableName, (String)"Could not get actualTableName, nodeEntry={}", (Object)each);
            result.add(generator.generateLogicDDL(databaseType, dataSource, schemaName, each.getLogicTableName(), actualTableName, parameter.getSqlParserEngine()));
        }
        return result;
    }
}

