/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.core.prepare;

import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import javax.sql.DataSource;
import lombok.Generated;
import org.apache.shardingsphere.data.pipeline.api.config.ImporterConfiguration;
import org.apache.shardingsphere.data.pipeline.api.config.ingest.DumperConfiguration;
import org.apache.shardingsphere.data.pipeline.api.datasource.PipelineDataSourceManager;
import org.apache.shardingsphere.data.pipeline.api.datasource.PipelineDataSourceWrapper;
import org.apache.shardingsphere.data.pipeline.api.datasource.config.PipelineDataSourceConfiguration;
import org.apache.shardingsphere.data.pipeline.api.datasource.config.impl.ShardingSpherePipelineDataSourceConfiguration;
import org.apache.shardingsphere.data.pipeline.api.datasource.config.impl.StandardPipelineDataSourceConfiguration;
import org.apache.shardingsphere.data.pipeline.api.ingest.position.IngestPosition;
import org.apache.shardingsphere.data.pipeline.api.job.progress.JobItemIncrementalTasksProgress;
import org.apache.shardingsphere.data.pipeline.core.check.datasource.DataSourceCheckerFactory;
import org.apache.shardingsphere.data.pipeline.core.ingest.position.PositionInitializerFactory;
import org.apache.shardingsphere.data.pipeline.core.prepare.datasource.DataSourcePreparer;
import org.apache.shardingsphere.data.pipeline.core.prepare.datasource.DataSourcePreparerFactory;
import org.apache.shardingsphere.data.pipeline.core.prepare.datasource.PrepareTargetSchemasParameter;
import org.apache.shardingsphere.data.pipeline.core.prepare.datasource.PrepareTargetTablesParameter;
import org.apache.shardingsphere.data.pipeline.spi.check.datasource.DataSourceChecker;
import org.apache.shardingsphere.data.pipeline.spi.ingest.position.PositionInitializer;
import org.apache.shardingsphere.infra.database.type.DatabaseType;
import org.apache.shardingsphere.infra.datasource.pool.creator.DataSourcePoolCreator;
import org.apache.shardingsphere.infra.datasource.props.DataSourceProperties;
import org.apache.shardingsphere.infra.yaml.config.swapper.resource.YamlDataSourceConfigurationSwapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PipelineJobPreparerUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PipelineJobPreparerUtils.class);
    private static final Set<String> INCREMENTAL_SUPPORTED_DATABASES = new HashSet<String>(Arrays.asList("MySQL", "PostgreSQL", "openGauss"));

    public static boolean isIncrementalSupported(String databaseType) {
        return INCREMENTAL_SUPPORTED_DATABASES.contains(databaseType);
    }

    public static void prepareTargetSchema(String databaseType, PrepareTargetSchemasParameter prepareTargetSchemasParameter) {
        Optional<DataSourcePreparer> dataSourcePreparer = DataSourcePreparerFactory.getInstance(databaseType);
        if (!dataSourcePreparer.isPresent()) {
            log.info("dataSourcePreparer null, ignore prepare target");
            return;
        }
        dataSourcePreparer.get().prepareTargetSchemas(prepareTargetSchemasParameter);
    }

    public static void prepareTargetTables(String databaseType, PrepareTargetTablesParameter prepareTargetTablesParameter) throws SQLException {
        Optional<DataSourcePreparer> dataSourcePreparer = DataSourcePreparerFactory.getInstance(databaseType);
        if (!dataSourcePreparer.isPresent()) {
            log.info("dataSourcePreparer null, ignore prepare target");
            return;
        }
        dataSourcePreparer.get().prepareTargetTables(prepareTargetTablesParameter);
    }

    public static IngestPosition<?> getIncrementalPosition(JobItemIncrementalTasksProgress initIncremental, DumperConfiguration dumperConfig, PipelineDataSourceManager dataSourceManager) throws SQLException {
        Optional position;
        if (null != initIncremental && (position = initIncremental.getIncrementalPosition(dumperConfig.getDataSourceName())).isPresent()) {
            return (IngestPosition)position.get();
        }
        String databaseType = dumperConfig.getDataSourceConfig().getDatabaseType().getType();
        PipelineDataSourceWrapper dataSource = dataSourceManager.getDataSource(dumperConfig.getDataSourceConfig());
        return PositionInitializerFactory.getInstance(databaseType).init((DataSource)dataSource, dumperConfig.getJobId());
    }

    public static void checkSourceDataSource(String databaseType, Collection<? extends DataSource> dataSources) {
        if (null == dataSources || dataSources.isEmpty()) {
            log.info("source data source is empty, skip check");
            return;
        }
        DataSourceChecker dataSourceChecker = DataSourceCheckerFactory.getInstance(databaseType);
        dataSourceChecker.checkConnection(dataSources);
        dataSourceChecker.checkPrivilege(dataSources);
        dataSourceChecker.checkVariable(dataSources);
    }

    public static void checkTargetDataSource(String databaseType, ImporterConfiguration importerConfig, Collection<? extends DataSource> targetDataSources) {
        DataSourceChecker dataSourceChecker = DataSourceCheckerFactory.getInstance(databaseType);
        if (null == targetDataSources || targetDataSources.isEmpty()) {
            log.info("target data source is empty, skip check");
            return;
        }
        dataSourceChecker.checkConnection(targetDataSources);
        dataSourceChecker.checkTargetTable(targetDataSources, importerConfig.getTableNameSchemaNameMapping(), importerConfig.getLogicTableNames());
    }

    public static void destroyPosition(String jobId, PipelineDataSourceConfiguration pipelineDataSourceConfig) throws SQLException {
        ShardingSpherePipelineDataSourceConfiguration dataSourceConfig;
        DatabaseType databaseType = pipelineDataSourceConfig.getDatabaseType();
        PositionInitializer positionInitializer = PositionInitializerFactory.getInstance(databaseType.getType());
        log.info("Cleanup database type:{}, data source type:{}", (Object)databaseType.getType(), (Object)pipelineDataSourceConfig.getType());
        if (pipelineDataSourceConfig instanceof ShardingSpherePipelineDataSourceConfiguration) {
            dataSourceConfig = (ShardingSpherePipelineDataSourceConfiguration)pipelineDataSourceConfig;
            for (DataSourceProperties each : new YamlDataSourceConfigurationSwapper().getDataSourcePropertiesMap(dataSourceConfig.getRootConfig()).values()) {
                PipelineDataSourceWrapper dataSource = new PipelineDataSourceWrapper(DataSourcePoolCreator.create((DataSourceProperties)each), databaseType);
                Throwable throwable = null;
                try {
                    positionInitializer.destroy((DataSource)dataSource, jobId);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (dataSource == null) continue;
                    if (throwable != null) {
                        try {
                            dataSource.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    dataSource.close();
                }
            }
        }
        if (pipelineDataSourceConfig instanceof StandardPipelineDataSourceConfiguration) {
            dataSourceConfig = (StandardPipelineDataSourceConfiguration)pipelineDataSourceConfig;
            try (PipelineDataSourceWrapper dataSource = new PipelineDataSourceWrapper(DataSourcePoolCreator.create((DataSourceProperties)((DataSourceProperties)dataSourceConfig.getDataSourceConfiguration())), databaseType);){
                positionInitializer.destroy((DataSource)dataSource, jobId);
            }
        }
    }
}

