/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.core.prepare;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import javax.sql.DataSource;
import lombok.Generated;
import org.apache.shardingsphere.data.pipeline.api.config.TaskConfiguration;
import org.apache.shardingsphere.data.pipeline.api.config.ingest.DumperConfiguration;
import org.apache.shardingsphere.data.pipeline.api.config.ingest.InventoryDumperConfiguration;
import org.apache.shardingsphere.data.pipeline.api.config.job.PipelineJobConfiguration;
import org.apache.shardingsphere.data.pipeline.api.context.PipelineJobItemContext;
import org.apache.shardingsphere.data.pipeline.api.context.PipelineProcessContext;
import org.apache.shardingsphere.data.pipeline.api.datasource.PipelineDataSourceManager;
import org.apache.shardingsphere.data.pipeline.api.datasource.PipelineDataSourceWrapper;
import org.apache.shardingsphere.data.pipeline.api.ingest.position.IngestPosition;
import org.apache.shardingsphere.data.pipeline.api.ingest.position.IntegerPrimaryKeyPosition;
import org.apache.shardingsphere.data.pipeline.api.ingest.position.PlaceholderPosition;
import org.apache.shardingsphere.data.pipeline.api.ingest.position.PrimaryKeyPosition;
import org.apache.shardingsphere.data.pipeline.api.ingest.position.StringPrimaryKeyPosition;
import org.apache.shardingsphere.data.pipeline.api.job.JobStatus;
import org.apache.shardingsphere.data.pipeline.api.job.progress.InventoryIncrementalJobItemProgress;
import org.apache.shardingsphere.data.pipeline.api.metadata.LogicTableName;
import org.apache.shardingsphere.data.pipeline.api.metadata.PipelineColumnMetaData;
import org.apache.shardingsphere.data.pipeline.core.exception.PipelineJobCreationException;
import org.apache.shardingsphere.data.pipeline.core.exception.PipelineJobPrepareFailedException;
import org.apache.shardingsphere.data.pipeline.core.execute.ExecuteEngine;
import org.apache.shardingsphere.data.pipeline.core.job.progress.listener.DefaultPipelineJobProgressListener;
import org.apache.shardingsphere.data.pipeline.core.metadata.loader.PipelineTableMetaDataLoader;
import org.apache.shardingsphere.data.pipeline.core.metadata.model.PipelineIndexMetaData;
import org.apache.shardingsphere.data.pipeline.core.metadata.model.PipelineTableMetaData;
import org.apache.shardingsphere.data.pipeline.core.sqlbuilder.PipelineSQLBuilderFactory;
import org.apache.shardingsphere.data.pipeline.core.task.InventoryTask;
import org.apache.shardingsphere.data.pipeline.core.util.PipelineJdbcUtils;
import org.apache.shardingsphere.data.pipeline.spi.ingest.channel.PipelineChannelCreator;
import org.apache.shardingsphere.data.pipeline.spi.ratelimit.JobRateLimitAlgorithm;
import org.apache.shardingsphere.infra.config.rule.data.pipeline.PipelineReadConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class InventoryTaskSplitter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(InventoryTaskSplitter.class);
    private final PipelineTableMetaDataLoader metaDataLoader;
    private final PipelineDataSourceManager dataSourceManager;
    private final ExecuteEngine importerExecuteEngine;
    private final PipelineDataSourceWrapper sourceDataSource;
    private final TaskConfiguration taskConfig;
    private final InventoryIncrementalJobItemProgress initProgress;

    public List<InventoryTask> splitInventoryData(PipelineJobItemContext jobItemContext) {
        LinkedList<InventoryTask> result = new LinkedList<InventoryTask>();
        PipelineChannelCreator pipelineChannelCreator = jobItemContext.getJobProcessContext().getPipelineChannelCreator();
        DefaultPipelineJobProgressListener jobProgressListener = new DefaultPipelineJobProgressListener(jobItemContext.getJobId(), jobItemContext.getShardingItem());
        for (InventoryDumperConfiguration each : this.splitDumperConfig(jobItemContext, this.taskConfig.getDumperConfig())) {
            result.add(new InventoryTask(each, this.taskConfig.getImporterConfig(), pipelineChannelCreator, this.dataSourceManager, (DataSource)this.sourceDataSource, this.metaDataLoader, this.importerExecuteEngine, jobProgressListener));
        }
        return result;
    }

    private Collection<InventoryDumperConfiguration> splitDumperConfig(PipelineJobItemContext jobItemContext, DumperConfiguration dumperConfig) {
        LinkedList<InventoryDumperConfiguration> result = new LinkedList<InventoryDumperConfiguration>();
        for (InventoryDumperConfiguration each : this.splitByTable(dumperConfig)) {
            result.addAll(this.splitByPrimaryKey(jobItemContext, (DataSource)this.sourceDataSource, this.metaDataLoader, each));
        }
        return result;
    }

    private Collection<InventoryDumperConfiguration> splitByTable(DumperConfiguration dumperConfig) {
        LinkedList<InventoryDumperConfiguration> result = new LinkedList<InventoryDumperConfiguration>();
        dumperConfig.getTableNameMap().forEach((key, value) -> {
            InventoryDumperConfiguration inventoryDumperConfig = new InventoryDumperConfiguration(dumperConfig);
            inventoryDumperConfig.setActualTableName(key.getOriginal());
            inventoryDumperConfig.setLogicTableName(value.getOriginal());
            inventoryDumperConfig.setPosition((IngestPosition)new PlaceholderPosition());
            result.add(inventoryDumperConfig);
        });
        return result;
    }

    private Collection<InventoryDumperConfiguration> splitByPrimaryKey(PipelineJobItemContext jobItemContext, DataSource dataSource, PipelineTableMetaDataLoader metaDataLoader, InventoryDumperConfiguration dumperConfig) {
        LinkedList<InventoryDumperConfiguration> result = new LinkedList<InventoryDumperConfiguration>();
        PipelineProcessContext ruleAlteredContext = jobItemContext.getJobProcessContext();
        PipelineReadConfiguration readConfig = ruleAlteredContext.getPipelineProcessConfig().getRead();
        int batchSize = readConfig.getBatchSize();
        JobRateLimitAlgorithm rateLimitAlgorithm = ruleAlteredContext.getReadRateLimitAlgorithm();
        Collection<IngestPosition<?>> inventoryPositions = this.getInventoryPositions(jobItemContext, dumperConfig, dataSource, metaDataLoader);
        int i = 0;
        for (IngestPosition<?> inventoryPosition : inventoryPositions) {
            InventoryDumperConfiguration splitDumperConfig = new InventoryDumperConfiguration((DumperConfiguration)dumperConfig);
            splitDumperConfig.setPosition(inventoryPosition);
            splitDumperConfig.setShardingItem(Integer.valueOf(i++));
            splitDumperConfig.setActualTableName(dumperConfig.getActualTableName());
            splitDumperConfig.setLogicTableName(dumperConfig.getLogicTableName());
            splitDumperConfig.setUniqueKey(dumperConfig.getUniqueKey());
            splitDumperConfig.setUniqueKeyDataType(dumperConfig.getUniqueKeyDataType());
            splitDumperConfig.setBatchSize(batchSize);
            splitDumperConfig.setRateLimitAlgorithm(rateLimitAlgorithm);
            result.add(splitDumperConfig);
        }
        return result;
    }

    private Collection<IngestPosition<?>> getInventoryPositions(PipelineJobItemContext jobItemContext, InventoryDumperConfiguration dumperConfig, DataSource dataSource, PipelineTableMetaDataLoader metaDataLoader) {
        String schemaName = dumperConfig.getSchemaName(new LogicTableName(dumperConfig.getLogicTableName()));
        String actualTableName = dumperConfig.getActualTableName();
        PipelineTableMetaData tableMetaData = metaDataLoader.getTableMetaData(schemaName, actualTableName);
        PipelineColumnMetaData uniqueKeyColumn = this.mustGetAnAppropriateUniqueKeyColumn(tableMetaData, actualTableName);
        if (null != this.initProgress && this.initProgress.getStatus() != JobStatus.PREPARING_FAILURE) {
            Collection<IngestPosition<?>> result = this.initProgress.getInventory().getInventoryPosition(dumperConfig.getActualTableName()).values();
            for (IngestPosition ingestPosition : result) {
                if (!(ingestPosition instanceof PrimaryKeyPosition)) continue;
                dumperConfig.setUniqueKey(uniqueKeyColumn.getName());
                dumperConfig.setUniqueKeyDataType(Integer.valueOf(uniqueKeyColumn.getDataType()));
                break;
            }
            return result;
        }
        dumperConfig.setUniqueKey(uniqueKeyColumn.getName());
        int uniqueKeyDataType = uniqueKeyColumn.getDataType();
        dumperConfig.setUniqueKeyDataType(Integer.valueOf(uniqueKeyDataType));
        if (PipelineJdbcUtils.isIntegerColumn(uniqueKeyDataType)) {
            return this.getPositionByIntegerPrimaryKeyRange(jobItemContext, dataSource, dumperConfig);
        }
        if (PipelineJdbcUtils.isStringColumn(uniqueKeyDataType)) {
            return this.getPositionByStringPrimaryKeyRange();
        }
        throw new PipelineJobCreationException(String.format("Can not split range for table %s, reason: primary key is not integer or string type", actualTableName));
    }

    private PipelineColumnMetaData mustGetAnAppropriateUniqueKeyColumn(PipelineTableMetaData tableMetaData, String tableName) {
        PipelineColumnMetaData column;
        if (null == tableMetaData) {
            throw new PipelineJobCreationException(String.format("Can not split range for table %s, reason: can not get table metadata ", tableName));
        }
        List<String> primaryKeys = tableMetaData.getPrimaryKeyColumns();
        if (primaryKeys.size() > 1) {
            throw new PipelineJobCreationException(String.format("Can not split range for table %s, reason: primary key is union primary", tableName));
        }
        if (1 == primaryKeys.size()) {
            return tableMetaData.getColumnMetaData(tableMetaData.getPrimaryKeyColumns().get(0));
        }
        Collection<PipelineIndexMetaData> uniqueIndexes = tableMetaData.getUniqueIndexes();
        if (uniqueIndexes.isEmpty()) {
            throw new PipelineJobCreationException(String.format("Can not split range for table %s, reason: no primary key or unique index", tableName));
        }
        if (1 == uniqueIndexes.size() && 1 == uniqueIndexes.iterator().next().getColumns().size() && !(column = uniqueIndexes.iterator().next().getColumns().get(0)).isNullable()) {
            return column;
        }
        throw new PipelineJobCreationException(String.format("Can not split range for table %s, reason: table contains multiple unique index or unique index contains nullable/multiple column(s)", tableName));
    }

    private Collection<IngestPosition<?>> getPositionByIntegerPrimaryKeyRange(PipelineJobItemContext jobItemContext, DataSource dataSource, InventoryDumperConfiguration dumperConfig) {
        LinkedList result = new LinkedList();
        PipelineJobConfiguration jobConfig = jobItemContext.getJobConfig();
        String sql = PipelineSQLBuilderFactory.getInstance(jobConfig.getSourceDatabaseType()).buildSplitByPrimaryKeyRangeSQL(dumperConfig.getSchemaName(new LogicTableName(dumperConfig.getLogicTableName())), dumperConfig.getActualTableName(), dumperConfig.getUniqueKey());
        int shardingSize = jobItemContext.getJobProcessContext().getPipelineProcessConfig().getRead().getShardingSize();
        try (Connection connection = dataSource.getConnection();
             PreparedStatement ps = connection.prepareStatement(sql);){
            long beginId = 0L;
            for (int i = 0; i < Integer.MAX_VALUE; ++i) {
                ps.setLong(1, beginId);
                ps.setLong(2, shardingSize);
                try (ResultSet rs = ps.executeQuery();){
                    if (!rs.next()) {
                        log.info("getPositionByPrimaryKeyRange, rs.next false, break");
                        break;
                    }
                    long endId = rs.getLong(1);
                    if (endId == 0L) {
                        log.info("getPositionByPrimaryKeyRange, endId is 0, break, tableName={}, primaryKey={}, beginId={}", new Object[]{dumperConfig.getActualTableName(), dumperConfig.getUniqueKey(), beginId});
                        break;
                    }
                    result.add((IngestPosition<?>)new IntegerPrimaryKeyPosition(beginId, endId));
                    beginId = endId + 1L;
                    continue;
                }
            }
            if (0 == result.size()) {
                result.add((IngestPosition<?>)new IntegerPrimaryKeyPosition(0L, 0L));
            }
        }
        catch (SQLException ex) {
            throw new PipelineJobPrepareFailedException(String.format("Split task for table %s by primary key %s error", dumperConfig.getActualTableName(), dumperConfig.getUniqueKey()), ex);
        }
        return result;
    }

    private Collection<IngestPosition<?>> getPositionByStringPrimaryKeyRange() {
        LinkedList result = new LinkedList();
        result.add((IngestPosition<?>)new StringPrimaryKeyPosition("!", "~"));
        return result;
    }

    @Generated
    public InventoryTaskSplitter(PipelineTableMetaDataLoader metaDataLoader, PipelineDataSourceManager dataSourceManager, ExecuteEngine importerExecuteEngine, PipelineDataSourceWrapper sourceDataSource, TaskConfiguration taskConfig, InventoryIncrementalJobItemProgress initProgress) {
        this.metaDataLoader = metaDataLoader;
        this.dataSourceManager = dataSourceManager;
        this.importerExecuteEngine = importerExecuteEngine;
        this.sourceDataSource = sourceDataSource;
        this.taskConfig = taskConfig;
        this.initProgress = initProgress;
    }
}

