/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.core.metadata.node;

import java.util.regex.Pattern;
import lombok.Generated;
import org.apache.shardingsphere.data.pipeline.api.job.JobType;

public final class PipelineMetaDataNode {
    private static final String JOB_PATTERN_PREFIX = "/pipeline/jobs/(j\\d{2}[0-9a-f]+)";
    public static final Pattern CONFIG_PATTERN = Pattern.compile("/pipeline/jobs/(j\\d{2}[0-9a-f]+)/config");
    public static final Pattern BARRIER_PATTERN = Pattern.compile("/pipeline/jobs/(j\\d{2}[0-9a-f]+)/barrier/(enable|disable)/\\d+");

    public static String getMetaDataDataSourcesPath(JobType jobType) {
        return String.join((CharSequence)"/", PipelineMetaDataNode.getMetaDataRootPath(jobType), "dataSources");
    }

    private static String getMetaDataRootPath(JobType jobType) {
        if (null != jobType) {
            return String.join((CharSequence)"/", "/pipeline", jobType.getLowercaseTypeName(), "metadata");
        }
        return String.join((CharSequence)"/", "/pipeline", "metadata");
    }

    public static String getMetaDataProcessConfigPath(JobType jobType) {
        return String.join((CharSequence)"/", PipelineMetaDataNode.getMetaDataRootPath(jobType), "processConfig");
    }

    public static String getElasticJobNamespace() {
        return PipelineMetaDataNode.getJobsPath();
    }

    private static String getJobsPath() {
        return String.join((CharSequence)"/", "/pipeline", "jobs");
    }

    public static String getJobRootPath(String jobId) {
        return String.join((CharSequence)"/", PipelineMetaDataNode.getJobsPath(), jobId);
    }

    public static String getJobOffsetItemPath(String jobId, int shardingItem) {
        return String.join((CharSequence)"/", PipelineMetaDataNode.getJobOffsetPath(jobId), Integer.toString(shardingItem));
    }

    public static String getJobOffsetPath(String jobId) {
        return String.join((CharSequence)"/", PipelineMetaDataNode.getJobRootPath(jobId), "offset");
    }

    public static String getJobConfigPath(String jobId) {
        return String.join((CharSequence)"/", PipelineMetaDataNode.getJobRootPath(jobId), "config");
    }

    public static String getJobCheckResultPath(String jobId) {
        return String.join((CharSequence)"/", PipelineMetaDataNode.getJobRootPath(jobId), "check", "result");
    }

    public static String getJobBarrierEnablePath(String jobId) {
        return String.join((CharSequence)"/", PipelineMetaDataNode.getJobRootPath(jobId), "barrier", "enable");
    }

    public static String getJobBarrierDisablePath(String jobId) {
        return String.join((CharSequence)"/", PipelineMetaDataNode.getJobRootPath(jobId), "barrier", "disable");
    }

    @Generated
    private PipelineMetaDataNode() {
    }
}

