/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.core.metadata.loader;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import org.apache.shardingsphere.data.pipeline.api.datasource.PipelineDataSourceWrapper;
import org.apache.shardingsphere.data.pipeline.api.metadata.PipelineColumnMetaData;
import org.apache.shardingsphere.data.pipeline.api.metadata.TableName;
import org.apache.shardingsphere.data.pipeline.core.metadata.model.PipelineIndexMetaData;
import org.apache.shardingsphere.data.pipeline.core.metadata.model.PipelineTableMetaData;
import org.apache.shardingsphere.infra.database.type.DatabaseTypeFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PipelineTableMetaDataLoader {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PipelineTableMetaDataLoader.class);
    private final PipelineDataSourceWrapper dataSource;
    private final Map<TableName, PipelineTableMetaData> tableMetaDataMap = new ConcurrentHashMap<TableName, PipelineTableMetaData>();

    public PipelineTableMetaData getTableMetaData(String schemaName, String tableName) {
        PipelineTableMetaData result = this.tableMetaDataMap.get(new TableName(tableName));
        if (null != result) {
            return result;
        }
        try {
            this.loadTableMetaData(schemaName, tableName);
        }
        catch (SQLException ex) {
            throw new RuntimeException(String.format("Load metadata for table '%s' failed", tableName), ex);
        }
        result = this.tableMetaDataMap.get(new TableName(tableName));
        if (null == result) {
            log.warn("getTableMetaData, can not load metadata for table '{}'", (Object)tableName);
        }
        return result;
    }

    private void loadTableMetaData(String schemaName, String tableNamePattern) throws SQLException {
        try (Connection connection = this.dataSource.getConnection();){
            long startMillis = System.currentTimeMillis();
            String schemaNameFinal = this.isSchemaAvailable() ? schemaName : null;
            Map<TableName, PipelineTableMetaData> tableMetaDataMap = this.loadTableMetaData0(connection, schemaNameFinal, tableNamePattern);
            log.info("loadTableMetaData, schemaNameFinal={}, tableNamePattern={}, result={}, cost time={} ms", new Object[]{schemaNameFinal, tableNamePattern, tableMetaDataMap, System.currentTimeMillis() - startMillis});
            this.tableMetaDataMap.putAll(tableMetaDataMap);
        }
    }

    private boolean isSchemaAvailable() {
        return DatabaseTypeFactory.getInstance((String)this.dataSource.getDatabaseType().getType()).isSchemaAvailable();
    }

    private Map<TableName, PipelineTableMetaData> loadTableMetaData0(Connection connection, String schemaName, String tableNamePattern) throws SQLException {
        String tableName;
        LinkedHashMap<String, Map> tablePipelineColumnMetaDataMap = new LinkedHashMap<String, Map>();
        ResultSet resultSet = connection.getMetaData().getColumns(connection.getCatalog(), schemaName, tableNamePattern, "%");
        Object object = null;
        try {
            while (resultSet.next()) {
                Set<String> primaryKeys;
                String columnName;
                int n = resultSet.getInt("ORDINAL_POSITION");
                tableName = resultSet.getString("TABLE_NAME");
                Map columnMetaDataMap = tablePipelineColumnMetaDataMap.computeIfAbsent(tableName, k -> new LinkedHashMap());
                if (columnMetaDataMap.containsKey(columnName = resultSet.getString("COLUMN_NAME"))) continue;
                int dataType = resultSet.getInt("DATA_TYPE");
                String dataTypeName = resultSet.getString("TYPE_NAME");
                try {
                    primaryKeys = this.loadPrimaryKeys(connection, schemaName, tableName);
                }
                catch (SQLException ex) {
                    log.error("loadPrimaryKeys failed, tableName={}", (Object)tableName);
                    throw ex;
                }
                boolean primaryKey = primaryKeys.contains(columnName);
                boolean isNullable = "YES".equals(resultSet.getString("IS_NULLABLE"));
                PipelineColumnMetaData columnMetaData = new PipelineColumnMetaData(n, columnName, dataType, dataTypeName, isNullable, primaryKey);
                columnMetaDataMap.put(columnName, columnMetaData);
            }
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (resultSet != null) {
                if (object != null) {
                    try {
                        resultSet.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    resultSet.close();
                }
            }
        }
        LinkedHashMap<TableName, PipelineTableMetaData> result = new LinkedHashMap<TableName, PipelineTableMetaData>();
        for (Map.Entry entry : tablePipelineColumnMetaDataMap.entrySet()) {
            tableName = (String)entry.getKey();
            result.put(new TableName(tableName), new PipelineTableMetaData(tableName, (Map)entry.getValue(), this.loadIndexesOfTable(connection, schemaName, (Map)entry.getValue(), tableName)));
        }
        return result;
    }

    private Collection<PipelineIndexMetaData> loadIndexesOfTable(Connection connection, String schemaName, Map<String, PipelineColumnMetaData> columns, String tableName) throws SQLException {
        LinkedHashMap<String, PipelineIndexMetaData> result = new LinkedHashMap<String, PipelineIndexMetaData>();
        LinkedHashMap<String, SortedMap> orderedColumnsOfIndexes = new LinkedHashMap<String, SortedMap>();
        try (ResultSet resultSet = connection.getMetaData().getIndexInfo(connection.getCatalog(), schemaName, tableName, true, false);){
            while (resultSet.next()) {
                String indexName = resultSet.getString("INDEX_NAME");
                if (null == indexName) continue;
                result.computeIfAbsent(indexName, unused -> new PipelineIndexMetaData(indexName, new LinkedList<PipelineColumnMetaData>()));
                orderedColumnsOfIndexes.computeIfAbsent(indexName, unused -> new TreeMap()).put(resultSet.getShort("ORDINAL_POSITION"), resultSet.getString("COLUMN_NAME"));
            }
        }
        for (PipelineIndexMetaData each : result.values()) {
            ((SortedMap)orderedColumnsOfIndexes.get(each.getName())).values().stream().map(columns::get).forEach(each.getColumns()::add);
        }
        return result.values();
    }

    private Set<String> loadPrimaryKeys(Connection connection, String schemaName, String tableName) throws SQLException {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        try (ResultSet resultSet = connection.getMetaData().getPrimaryKeys(connection.getCatalog(), schemaName, tableName);){
            while (resultSet.next()) {
                result.add(resultSet.getString("COLUMN_NAME"));
            }
        }
        return result;
    }

    @Generated
    public PipelineTableMetaDataLoader(PipelineDataSourceWrapper dataSource) {
        this.dataSource = dataSource;
    }
}

