/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.core.job.progress.yaml;

import com.google.common.base.Strings;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.shardingsphere.data.pipeline.api.ingest.position.FinishedPosition;
import org.apache.shardingsphere.data.pipeline.api.ingest.position.IngestPosition;
import org.apache.shardingsphere.data.pipeline.api.ingest.position.PlaceholderPosition;
import org.apache.shardingsphere.data.pipeline.api.ingest.position.PrimaryKeyPositionFactory;
import org.apache.shardingsphere.data.pipeline.api.job.progress.JobItemInventoryTasksProgress;
import org.apache.shardingsphere.data.pipeline.api.task.progress.InventoryTaskProgress;
import org.apache.shardingsphere.data.pipeline.core.job.progress.yaml.YamlJobItemInventoryTasksProgress;

public final class YamlJobItemInventoryTasksProgressSwapper {
    public YamlJobItemInventoryTasksProgress swapToYaml(JobItemInventoryTasksProgress progress) {
        YamlJobItemInventoryTasksProgress result = new YamlJobItemInventoryTasksProgress();
        if (null != progress) {
            result.setFinished(this.getFinished(progress));
            result.setUnfinished(this.getUnfinished(progress));
        }
        return result;
    }

    private String[] getFinished(JobItemInventoryTasksProgress progress) {
        return (String[])progress.getInventoryTaskProgressMap().entrySet().stream().filter(entry -> ((InventoryTaskProgress)entry.getValue()).getPosition() instanceof FinishedPosition).map(Map.Entry::getKey).toArray(String[]::new);
    }

    private Map<String, String> getUnfinished(JobItemInventoryTasksProgress progress) {
        return progress.getInventoryTaskProgressMap().entrySet().stream().filter(entry -> !(((InventoryTaskProgress)entry.getValue()).getPosition() instanceof FinishedPosition)).collect(Collectors.toMap(Map.Entry::getKey, entry -> ((InventoryTaskProgress)entry.getValue()).getPosition().toString()));
    }

    public JobItemInventoryTasksProgress swapToObject(YamlJobItemInventoryTasksProgress yamlProgress) {
        if (null == yamlProgress) {
            return new JobItemInventoryTasksProgress(Collections.emptyMap());
        }
        LinkedHashMap<String, InventoryTaskProgress> taskProgressMap = new LinkedHashMap<String, InventoryTaskProgress>();
        taskProgressMap.putAll(Arrays.stream(yamlProgress.getFinished()).collect(Collectors.toMap(key -> key, value -> new InventoryTaskProgress((IngestPosition)new FinishedPosition()))));
        taskProgressMap.putAll(yamlProgress.getUnfinished().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, this.getInventoryTaskProgressFunction())));
        return new JobItemInventoryTasksProgress(taskProgressMap);
    }

    private Function<Map.Entry<String, String>, InventoryTaskProgress> getInventoryTaskProgressFunction() {
        return entry -> new InventoryTaskProgress((IngestPosition)(Strings.isNullOrEmpty((String)((String)entry.getValue())) ? new PlaceholderPosition() : PrimaryKeyPositionFactory.newInstance((String)((String)entry.getValue()))));
    }
}

