/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.core.job.progress.yaml;

import java.util.Collections;
import org.apache.shardingsphere.data.pipeline.api.job.progress.JobItemIncrementalTasksProgress;
import org.apache.shardingsphere.data.pipeline.api.task.progress.IncrementalTaskProgress;
import org.apache.shardingsphere.data.pipeline.core.ingest.position.PositionInitializerFactory;
import org.apache.shardingsphere.data.pipeline.core.job.progress.yaml.YamlJobItemIncrementalTasksProgress;

public final class YamlJobItemIncrementalTasksProgressSwapper {
    public YamlJobItemIncrementalTasksProgress swapToYaml(JobItemIncrementalTasksProgress progress) {
        if (null == progress) {
            return new YamlJobItemIncrementalTasksProgress();
        }
        return progress.getIncrementalTaskProgressMap().entrySet().stream().map(entry -> {
            YamlJobItemIncrementalTasksProgress result = new YamlJobItemIncrementalTasksProgress();
            result.setDataSourceName((String)entry.getKey());
            result.setPosition(((IncrementalTaskProgress)entry.getValue()).getPosition().toString());
            result.setDelay(((IncrementalTaskProgress)entry.getValue()).getIncrementalTaskDelay());
            return result;
        }).findAny().orElse(new YamlJobItemIncrementalTasksProgress());
    }

    public JobItemIncrementalTasksProgress swapToObject(String databaseType, YamlJobItemIncrementalTasksProgress yamlProgress) {
        if (null == yamlProgress) {
            return new JobItemIncrementalTasksProgress(Collections.emptyMap());
        }
        IncrementalTaskProgress taskProgress = new IncrementalTaskProgress();
        taskProgress.setPosition(PositionInitializerFactory.getInstance(databaseType).init(yamlProgress.getPosition()));
        taskProgress.setIncrementalTaskDelay(yamlProgress.getDelay());
        return new JobItemIncrementalTasksProgress(Collections.singletonMap(yamlProgress.getDataSourceName(), taskProgress));
    }
}

