/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.core.job;

import org.apache.shardingsphere.data.pipeline.api.job.JobType;
import org.apache.shardingsphere.data.pipeline.api.job.PipelineJobId;

public final class PipelineJobIdUtils {
    public static String marshalJobIdCommonPrefix(PipelineJobId pipelineJobId) {
        return 'j' + pipelineJobId.getJobTypeCode() + pipelineJobId.getFormatVersion();
    }

    public static JobType parseJobType(String jobId) {
        if (jobId.length() <= 3) {
            throw new IllegalArgumentException("Invalid jobId length, jobId=" + jobId);
        }
        if ('j' != jobId.charAt(0)) {
            throw new IllegalArgumentException("Invalid jobId, first char=" + jobId.charAt(0));
        }
        String typeCode = jobId.substring(1, 3);
        JobType result = JobType.valueOfByCode((String)typeCode);
        if (null == result) {
            throw new IllegalArgumentException("Could not get JobType by '" + typeCode + "', jobId: " + jobId);
        }
        return result;
    }
}

