/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.core.job;

import com.google.common.base.Preconditions;
import lombok.Generated;
import lombok.NonNull;
import org.apache.shardingsphere.data.pipeline.api.job.JobType;
import org.apache.shardingsphere.data.pipeline.api.job.PipelineJobId;

public abstract class AbstractPipelineJobId
implements PipelineJobId {
    @NonNull
    private final JobType jobType;
    @NonNull
    private final String formatVersion;

    public AbstractPipelineJobId(@NonNull JobType jobType, @NonNull String formatVersion) {
        if (jobType == null) {
            throw new NullPointerException("jobType is marked non-null but is null");
        }
        if (formatVersion == null) {
            throw new NullPointerException("formatVersion is marked non-null but is null");
        }
        this.jobType = jobType;
        Preconditions.checkArgument((2 == formatVersion.length() ? 1 : 0) != 0, (Object)"formatVersion length is not 2");
        this.formatVersion = formatVersion;
    }

    public final String getJobTypeCode() {
        return this.jobType.getTypeCode();
    }

    @NonNull
    @Generated
    public JobType getJobType() {
        return this.jobType;
    }

    @NonNull
    @Generated
    public String getFormatVersion() {
        return this.formatVersion;
    }

    @Generated
    public String toString() {
        return "AbstractPipelineJobId(jobType=" + this.getJobType() + ", formatVersion=" + this.getFormatVersion() + ")";
    }
}

