/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.core.ingest.channel.memory;

import java.util.BitSet;
import java.util.LinkedList;
import java.util.List;

public final class ManualBitSet {
    private static final int BIT_SET_SIZE = 1024;
    private final List<BitSet> bitSets = new LinkedList<BitSet>();
    private long startIndex;

    public synchronized void set(long bitIndex) {
        int correctIndex = (int)(bitIndex - this.startIndex);
        int listIndex = correctIndex / 1024;
        for (int i = this.bitSets.size(); i <= listIndex; ++i) {
            this.bitSets.add(new BitSet(1024));
        }
        this.bitSets.get(listIndex).set(correctIndex % 1024);
    }

    public synchronized BitSet get(long fromIndex, long toIndex) {
        if (fromIndex >= toIndex) {
            return new BitSet();
        }
        BitSet result = new BitSet((int)(toIndex - fromIndex));
        int correctFromIndex = (int)(fromIndex - this.startIndex);
        int correctToIndex = (int)(toIndex - this.startIndex);
        int listFromIndex = correctFromIndex / 1024;
        int listToIndex = correctToIndex / 1024;
        int k = 0;
        for (int i = listFromIndex; i <= listToIndex && i < this.bitSets.size(); ++i) {
            BitSet bitSet = this.bitSets.get(i);
            int begin = i == listFromIndex ? correctFromIndex % 1024 : 0;
            int end = i == listToIndex ? correctToIndex % 1024 : 1024;
            for (int j = begin; j < end; ++j) {
                if (bitSet.get(j)) {
                    result.set(k, true);
                }
                ++k;
            }
        }
        return result;
    }

    public synchronized long getEndIndex(long fromIndex, int size) {
        if (size == 0) {
            return fromIndex;
        }
        int correctIndex = fromIndex < this.startIndex ? 0 : (int)(fromIndex - this.startIndex);
        int listIndex = correctIndex / 1024;
        int count = size;
        for (int i = listIndex; i < this.bitSets.size(); ++i) {
            int begin;
            for (int j = begin = i == listIndex ? correctIndex % 1024 : 0; j < 1024; ++j) {
                if (!this.bitSets.get(i).get(j) || --count != 0) continue;
                return this.startIndex + (long)i * 1024L + (long)j + 1L;
            }
        }
        throw new IndexOutOfBoundsException(String.format("BitSets(%s) do not have enough data from %d count %d", this.bitSets, correctIndex, size));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear(long bitIndex) {
        if (bitIndex - this.startIndex > 1024L) {
            ManualBitSet manualBitSet = this;
            synchronized (manualBitSet) {
                int count = Math.min(this.bitSets.size(), (int)((bitIndex - this.startIndex) / 1024L));
                if (count > 0) {
                    this.bitSets.subList(0, count).clear();
                    this.startIndex += (long)count * 1024L;
                }
            }
        }
    }
}

