/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.core.execute;

import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import lombok.Generated;
import org.apache.shardingsphere.data.pipeline.api.executor.LifecycleExecutor;
import org.apache.shardingsphere.data.pipeline.core.execute.ExecuteCallback;
import org.apache.shardingsphere.infra.executor.kernel.thread.ExecutorThreadFactoryBuilder;

public final class ExecuteEngine {
    private static final String SCALING_THREAD_PREFIX = "Scaling-";
    private static final String SCALING_THREAD_SUFFIX = "-%d";
    private final ExecutorService executorService;

    public static ExecuteEngine newCachedThreadInstance(String threadName) {
        String threadNameFormat = SCALING_THREAD_PREFIX + threadName + SCALING_THREAD_SUFFIX;
        return new ExecuteEngine(Executors.newCachedThreadPool(ExecutorThreadFactoryBuilder.build((String)threadNameFormat)));
    }

    public static ExecuteEngine newFixedThreadInstance(int threadNumber, String threadName) {
        String threadNameFormat = SCALING_THREAD_PREFIX + threadName + SCALING_THREAD_SUFFIX;
        return new ExecuteEngine(Executors.newFixedThreadPool(threadNumber, ExecutorThreadFactoryBuilder.build((String)threadNameFormat)));
    }

    public Future<?> submit(LifecycleExecutor lifecycleExecutor, ExecuteCallback executeCallback) {
        return CompletableFuture.runAsync((Runnable)lifecycleExecutor, this.executorService).whenCompleteAsync((unused, throwable) -> {
            if (null == throwable) {
                executeCallback.onSuccess();
            } else {
                Throwable cause = throwable.getCause();
                executeCallback.onFailure(null != cause ? cause : throwable);
            }
        }, (Executor)this.executorService);
    }

    public Future<?> submitAll(Collection<? extends LifecycleExecutor> lifecycleExecutors, ExecuteCallback executeCallback) {
        CompletableFuture[] futures = new CompletableFuture[lifecycleExecutors.size()];
        int i = 0;
        for (LifecycleExecutor lifecycleExecutor : lifecycleExecutors) {
            futures[i++] = CompletableFuture.runAsync((Runnable)lifecycleExecutor, this.executorService);
        }
        return CompletableFuture.allOf(futures).whenCompleteAsync((unused, throwable) -> {
            if (null == throwable) {
                executeCallback.onSuccess();
            } else {
                Throwable cause = throwable.getCause();
                executeCallback.onFailure(null != cause ? cause : throwable);
            }
        }, (Executor)this.executorService);
    }

    @Generated
    private ExecuteEngine(ExecutorService executorService) {
        this.executorService = executorService;
    }
}

