/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.core.context;

import lombok.Generated;
import org.apache.commons.lang3.concurrent.LazyInitializer;
import org.apache.shardingsphere.data.pipeline.api.context.PipelineProcessContext;
import org.apache.shardingsphere.data.pipeline.core.execute.ExecuteEngine;
import org.apache.shardingsphere.data.pipeline.core.util.PipelineProcessConfigurationUtils;
import org.apache.shardingsphere.data.pipeline.spi.ingest.channel.PipelineChannelCreator;
import org.apache.shardingsphere.data.pipeline.spi.ingest.channel.PipelineChannelCreatorFactory;
import org.apache.shardingsphere.data.pipeline.spi.ratelimit.JobRateLimitAlgorithm;
import org.apache.shardingsphere.data.pipeline.spi.ratelimit.JobRateLimitAlgorithmFactory;
import org.apache.shardingsphere.infra.config.algorithm.AlgorithmConfiguration;
import org.apache.shardingsphere.infra.config.rule.data.pipeline.PipelineProcessConfiguration;
import org.apache.shardingsphere.infra.config.rule.data.pipeline.PipelineReadConfiguration;
import org.apache.shardingsphere.infra.config.rule.data.pipeline.PipelineWriteConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractPipelineProcessContext
implements PipelineProcessContext {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractPipelineProcessContext.class);
    private final PipelineProcessConfiguration pipelineProcessConfig;
    private final JobRateLimitAlgorithm readRateLimitAlgorithm;
    private final JobRateLimitAlgorithm writeRateLimitAlgorithm;
    private final PipelineChannelCreator pipelineChannelCreator;
    private final LazyInitializer<ExecuteEngine> inventoryDumperExecuteEngineLazyInitializer;
    private final LazyInitializer<ExecuteEngine> incrementalDumperExecuteEngineLazyInitializer;
    private final LazyInitializer<ExecuteEngine> importerExecuteEngineLazyInitializer;

    public AbstractPipelineProcessContext(final String jobId, PipelineProcessConfiguration originalProcessConfig) {
        PipelineProcessConfiguration processConfig;
        this.pipelineProcessConfig = processConfig = PipelineProcessConfigurationUtils.convertWithDefaultValue(originalProcessConfig);
        final PipelineReadConfiguration readConfig = processConfig.getRead();
        AlgorithmConfiguration readRateLimiter = readConfig.getRateLimiter();
        this.readRateLimitAlgorithm = null != readRateLimiter ? JobRateLimitAlgorithmFactory.newInstance((AlgorithmConfiguration)readRateLimiter) : null;
        final PipelineWriteConfiguration writeConfig = processConfig.getWrite();
        AlgorithmConfiguration writeRateLimiter = writeConfig.getRateLimiter();
        this.writeRateLimitAlgorithm = null != writeRateLimiter ? JobRateLimitAlgorithmFactory.newInstance((AlgorithmConfiguration)writeRateLimiter) : null;
        AlgorithmConfiguration streamChannel = processConfig.getStreamChannel();
        this.pipelineChannelCreator = PipelineChannelCreatorFactory.newInstance((AlgorithmConfiguration)streamChannel);
        this.inventoryDumperExecuteEngineLazyInitializer = new LazyInitializer<ExecuteEngine>(){

            protected ExecuteEngine initialize() {
                return ExecuteEngine.newFixedThreadInstance(readConfig.getWorkerThread(), "Inventory-" + jobId);
            }
        };
        this.incrementalDumperExecuteEngineLazyInitializer = new LazyInitializer<ExecuteEngine>(){

            protected ExecuteEngine initialize() {
                return ExecuteEngine.newCachedThreadInstance("Incremental-" + jobId);
            }
        };
        this.importerExecuteEngineLazyInitializer = new LazyInitializer<ExecuteEngine>(){

            protected ExecuteEngine initialize() {
                return ExecuteEngine.newFixedThreadInstance(writeConfig.getWorkerThread(), "Importer-" + jobId);
            }
        };
    }

    public ExecuteEngine getInventoryDumperExecuteEngine() {
        return (ExecuteEngine)this.inventoryDumperExecuteEngineLazyInitializer.get();
    }

    public ExecuteEngine getIncrementalDumperExecuteEngine() {
        return (ExecuteEngine)this.incrementalDumperExecuteEngineLazyInitializer.get();
    }

    public ExecuteEngine getImporterExecuteEngine() {
        return (ExecuteEngine)this.importerExecuteEngineLazyInitializer.get();
    }

    @Generated
    public PipelineProcessConfiguration getPipelineProcessConfig() {
        return this.pipelineProcessConfig;
    }

    @Generated
    public JobRateLimitAlgorithm getReadRateLimitAlgorithm() {
        return this.readRateLimitAlgorithm;
    }

    @Generated
    public JobRateLimitAlgorithm getWriteRateLimitAlgorithm() {
        return this.writeRateLimitAlgorithm;
    }

    @Generated
    public PipelineChannelCreator getPipelineChannelCreator() {
        return this.pipelineChannelCreator;
    }

    @Generated
    public LazyInitializer<ExecuteEngine> getInventoryDumperExecuteEngineLazyInitializer() {
        return this.inventoryDumperExecuteEngineLazyInitializer;
    }

    @Generated
    public LazyInitializer<ExecuteEngine> getIncrementalDumperExecuteEngineLazyInitializer() {
        return this.incrementalDumperExecuteEngineLazyInitializer;
    }

    @Generated
    public LazyInitializer<ExecuteEngine> getImporterExecuteEngineLazyInitializer() {
        return this.importerExecuteEngineLazyInitializer;
    }
}

