/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.core.check.datasource;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import javax.sql.DataSource;
import lombok.Generated;
import org.apache.shardingsphere.data.pipeline.api.config.TableNameSchemaNameMapping;
import org.apache.shardingsphere.data.pipeline.core.exception.PipelineJobPrepareFailedException;
import org.apache.shardingsphere.data.pipeline.core.sqlbuilder.PipelineSQLBuilderFactory;
import org.apache.shardingsphere.data.pipeline.spi.check.datasource.DataSourceChecker;
import org.apache.shardingsphere.data.pipeline.spi.sqlbuilder.PipelineSQLBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDataSourceChecker
implements DataSourceChecker {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractDataSourceChecker.class);

    public final void checkConnection(Collection<? extends DataSource> dataSources) {
        try {
            for (DataSource dataSource : dataSources) {
                dataSource.getConnection().close();
            }
        }
        catch (SQLException ex) {
            throw new PipelineJobPrepareFailedException("Data sources can not connect.", ex);
        }
    }

    public final void checkTargetTable(Collection<? extends DataSource> dataSources, TableNameSchemaNameMapping tableNameSchemaNameMapping, Collection<String> logicTableNames) {
        try {
            for (DataSource dataSource : dataSources) {
                this.checkEmpty(dataSource, tableNameSchemaNameMapping, logicTableNames);
            }
        }
        catch (SQLException ex) {
            throw new PipelineJobPrepareFailedException("Check target table failed.", ex);
        }
    }

    private void checkEmpty(DataSource dataSource, TableNameSchemaNameMapping tableNameSchemaNameMapping, Collection<String> logicTableNames) throws SQLException {
        for (String each : logicTableNames) {
            String sql = this.getSQLBuilder().buildCheckEmptySQL(tableNameSchemaNameMapping.getSchemaName(each), each);
            log.info("checkEmpty, sql={}", (Object)sql);
            Connection connection = dataSource.getConnection();
            Throwable throwable = null;
            try {
                PreparedStatement preparedStatement = connection.prepareStatement(sql);
                Throwable throwable2 = null;
                try {
                    ResultSet resultSet = preparedStatement.executeQuery();
                    Throwable throwable3 = null;
                    try {
                        if (!resultSet.next()) continue;
                        throw new PipelineJobPrepareFailedException(String.format("Target table `%s` is not empty, sql: %s.", each, sql));
                    }
                    catch (Throwable throwable4) {
                        throwable3 = throwable4;
                        throw throwable4;
                    }
                    finally {
                        if (resultSet == null) continue;
                        if (throwable3 != null) {
                            try {
                                resultSet.close();
                            }
                            catch (Throwable throwable5) {
                                throwable3.addSuppressed(throwable5);
                            }
                            continue;
                        }
                        resultSet.close();
                    }
                }
                catch (Throwable throwable6) {
                    throwable2 = throwable6;
                    throw throwable6;
                }
                finally {
                    if (preparedStatement == null) continue;
                    if (throwable2 != null) {
                        try {
                            preparedStatement.close();
                        }
                        catch (Throwable throwable7) {
                            throwable2.addSuppressed(throwable7);
                        }
                        continue;
                    }
                    preparedStatement.close();
                }
            }
            catch (Throwable throwable8) {
                throwable = throwable8;
                throw throwable8;
            }
            finally {
                if (connection == null) continue;
                if (throwable != null) {
                    try {
                        connection.close();
                    }
                    catch (Throwable throwable9) {
                        throwable.addSuppressed(throwable9);
                    }
                    continue;
                }
                connection.close();
            }
        }
    }

    private PipelineSQLBuilder getSQLBuilder() {
        return PipelineSQLBuilderFactory.getInstance(this.getDatabaseType());
    }

    protected abstract String getDatabaseType();

    public String getType() {
        return this.getDatabaseType();
    }
}

