/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.core.check.consistency.algorithm;

import java.math.BigDecimal;
import java.sql.SQLXML;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import lombok.Generated;
import lombok.NonNull;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.shardingsphere.data.pipeline.api.check.consistency.DataConsistencyCalculateParameter;
import org.apache.shardingsphere.data.pipeline.core.check.consistency.DataConsistencyCheckUtils;
import org.apache.shardingsphere.data.pipeline.core.check.consistency.algorithm.AbstractStreamingDataConsistencyCalculateAlgorithm;
import org.apache.shardingsphere.data.pipeline.core.sqlbuilder.PipelineSQLBuilderFactory;
import org.apache.shardingsphere.data.pipeline.spi.sqlbuilder.PipelineSQLBuilder;
import org.apache.shardingsphere.infra.database.type.DatabaseTypeFactory;
import org.apache.shardingsphere.infra.util.spi.type.typed.TypedSPI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DataMatchDataConsistencyCalculateAlgorithm
extends AbstractStreamingDataConsistencyCalculateAlgorithm {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DataMatchDataConsistencyCalculateAlgorithm.class);
    private static final Collection<String> SUPPORTED_DATABASE_TYPES = DatabaseTypeFactory.getInstances().stream().map(TypedSPI::getType).collect(Collectors.toList());
    private static final String CHUNK_SIZE_KEY = "chunk-size";
    private static final int DEFAULT_CHUNK_SIZE = 1000;
    private Properties props;
    private int chunkSize;
    private final Map<String, String> firstSQLCache = new ConcurrentHashMap<String, String>();
    private final Map<String, String> laterSQLCache = new ConcurrentHashMap<String, String>();

    public void init(Properties props) {
        this.props = props;
        this.chunkSize = this.getChunkSize(props);
    }

    private int getChunkSize(Properties props) {
        int result = Integer.parseInt(props.getProperty(CHUNK_SIZE_KEY, "1000"));
        if (result <= 0) {
            log.warn("Invalid result={}, use default value", (Object)result);
            return 1000;
        }
        return result;
    }

    /*
     * Exception decompiling
     */
    @Override
    protected Optional<Object> calculateChunk(DataConsistencyCalculateParameter parameter) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private String getQuerySQL(DataConsistencyCalculateParameter parameter) {
        PipelineSQLBuilder sqlBuilder = PipelineSQLBuilderFactory.getInstance(parameter.getDatabaseType());
        String logicTableName = parameter.getLogicTableName();
        String schemaName = parameter.getTableNameSchemaNameMapping().getSchemaName(logicTableName);
        String uniqueKey = parameter.getUniqueKey().getName();
        String cacheKey = parameter.getDatabaseType() + "-" + (DatabaseTypeFactory.getInstance((String)parameter.getDatabaseType()).isSchemaAvailable() ? schemaName.toLowerCase() + "." + logicTableName.toLowerCase() : logicTableName.toLowerCase());
        if (null == parameter.getPreviousCalculatedResult()) {
            return this.firstSQLCache.computeIfAbsent(cacheKey, s -> sqlBuilder.buildChunkedQuerySQL(schemaName, logicTableName, uniqueKey, true));
        }
        return this.laterSQLCache.computeIfAbsent(cacheKey, s -> sqlBuilder.buildChunkedQuerySQL(schemaName, logicTableName, uniqueKey, false));
    }

    public String getType() {
        return "DATA_MATCH";
    }

    public Collection<String> getSupportedDatabaseTypes() {
        return SUPPORTED_DATABASE_TYPES;
    }

    public String getDescription() {
        return "Match raw data of records.";
    }

    @Generated
    public Properties getProps() {
        return this.props;
    }

    private static final class CalculatedResult {
        @NonNull
        private final Object maxUniqueKeyValue;
        private final int recordCount;
        private final Collection<Collection<Object>> records;

        public boolean equals(@NonNull Object o) {
            if (o == null) {
                throw new NullPointerException("o is marked non-null but is null");
            }
            if (this == o) {
                return true;
            }
            if (!(o instanceof CalculatedResult)) {
                log.warn("CalculatedResult type not match, o.className={}", (Object)o.getClass().getName());
                return false;
            }
            CalculatedResult that = (CalculatedResult)o;
            boolean equalsFirst = new EqualsBuilder().append(this.getRecordCount(), that.getRecordCount()).append(this.getMaxUniqueKeyValue(), that.getMaxUniqueKeyValue()).isEquals();
            if (!equalsFirst) {
                log.warn("recordCount or maxUniqueKeyValue not match, recordCount1={}, recordCount2={}, maxUniqueKeyValue1={}, maxUniqueKeyValue2={}", new Object[]{this.getRecordCount(), that.getRecordCount(), this.getMaxUniqueKeyValue(), that.getMaxUniqueKeyValue()});
                return false;
            }
            Iterator<Collection<Object>> thisIterator = this.records.iterator();
            Iterator<Collection<Object>> thatIterator = that.records.iterator();
            while (thisIterator.hasNext() && thatIterator.hasNext()) {
                Collection<Object> thisNext = thisIterator.next();
                Collection<Object> thatNext = thatIterator.next();
                if (thisNext.size() != thatNext.size()) {
                    log.warn("record column size not match, size1={}, size2={}, record1={}, record2={}", new Object[]{thisNext.size(), thatNext.size(), thisNext, thatNext});
                    return false;
                }
                Iterator<Object> thisNextIterator = thisNext.iterator();
                Iterator<Object> thatNextIterator = thatNext.iterator();
                while (thisNextIterator.hasNext() && thatNextIterator.hasNext()) {
                    Object thisResult = thisNextIterator.next();
                    Object thatResult = thatNextIterator.next();
                    if (thisResult instanceof SQLXML && thatResult instanceof SQLXML) {
                        return ((SQLXML)thisResult).getString().equals(((SQLXML)thatResult).getString());
                    }
                    if (thisResult instanceof Integer && thatResult instanceof Long) {
                        return ((Integer)thisResult).longValue() == ((Long)thatResult).longValue();
                    }
                    boolean matched = thisResult instanceof BigDecimal && thatResult instanceof BigDecimal ? DataConsistencyCheckUtils.isBigDecimalEquals((BigDecimal)thisResult, (BigDecimal)thatResult) : new EqualsBuilder().append(thisResult, thatResult).isEquals();
                    if (matched) continue;
                    log.warn("record column value not match, value1={}, value2={}, value1.class={}, value2.class={}, record1={}, record2={}", new Object[]{thisResult, thatResult, null != thisResult ? thisResult.getClass().getName() : "", null != thatResult ? thatResult.getClass().getName() : "", thisNext, thatNext});
                    return false;
                }
            }
            return true;
        }

        public int hashCode() {
            return new HashCodeBuilder(17, 37).append(this.getMaxUniqueKeyValue()).append(this.getRecordCount()).append(this.getRecords()).toHashCode();
        }

        @Generated
        public CalculatedResult(@NonNull Object maxUniqueKeyValue, int recordCount, Collection<Collection<Object>> records) {
            if (maxUniqueKeyValue == null) {
                throw new NullPointerException("maxUniqueKeyValue is marked non-null but is null");
            }
            this.maxUniqueKeyValue = maxUniqueKeyValue;
            this.recordCount = recordCount;
            this.records = records;
        }

        @NonNull
        @Generated
        public Object getMaxUniqueKeyValue() {
            return this.maxUniqueKeyValue;
        }

        @Generated
        public int getRecordCount() {
            return this.recordCount;
        }

        @Generated
        public Collection<Collection<Object>> getRecords() {
            return this.records;
        }
    }
}

