/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.core.check.consistency.algorithm;

import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.Properties;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import lombok.Generated;
import org.apache.shardingsphere.data.pipeline.api.check.consistency.DataConsistencyCalculateParameter;
import org.apache.shardingsphere.data.pipeline.core.exception.PipelineDataConsistencyCheckFailedException;
import org.apache.shardingsphere.data.pipeline.core.sqlbuilder.PipelineSQLBuilderFactory;
import org.apache.shardingsphere.data.pipeline.spi.check.consistency.DataConsistencyCalculateAlgorithm;
import org.apache.shardingsphere.data.pipeline.spi.sqlbuilder.PipelineSQLBuilder;
import org.apache.shardingsphere.infra.database.type.dialect.MySQLDatabaseType;

public final class CRC32MatchDataConsistencyCalculateAlgorithm
implements DataConsistencyCalculateAlgorithm {
    private static final Collection<String> SUPPORTED_DATABASE_TYPES = Collections.singletonList(new MySQLDatabaseType().getType());
    private Properties props;

    public void init(Properties props) {
        this.props = props;
    }

    public Iterable<Object> calculate(DataConsistencyCalculateParameter parameter) {
        PipelineSQLBuilder sqlBuilder = PipelineSQLBuilderFactory.getInstance(parameter.getDatabaseType());
        return Collections.unmodifiableList(parameter.getColumnNames().stream().map(each -> this.calculateCRC32(sqlBuilder, parameter, (String)each)).collect(Collectors.toList()));
    }

    private long calculateCRC32(PipelineSQLBuilder sqlBuilder, DataConsistencyCalculateParameter parameter, String columnName) {
        String logicTableName = parameter.getLogicTableName();
        String schemaName = parameter.getTableNameSchemaNameMapping().getSchemaName(logicTableName);
        Optional sql = sqlBuilder.buildCRC32SQL(schemaName, logicTableName, columnName);
        if (!sql.isPresent()) {
            throw new PipelineDataConsistencyCheckFailedException(String.format("Unsupported CRC32 data consistency calculate algorithm with database type `%s`", parameter.getDatabaseType()));
        }
        try {
            return this.calculateCRC32((DataSource)parameter.getDataSource(), (String)sql.get());
        }
        catch (SQLException ex) {
            throw new PipelineDataConsistencyCheckFailedException(String.format("Table `%s` data check failed.", logicTableName), ex);
        }
    }

    /*
     * Exception decompiling
     */
    private long calculateCRC32(DataSource dataSource, String sql) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public String getType() {
        return "CRC32_MATCH";
    }

    public Collection<String> getSupportedDatabaseTypes() {
        return SUPPORTED_DATABASE_TYPES;
    }

    public String getDescription() {
        return "Match CRC32 of records.";
    }

    @Generated
    public Properties getProps() {
        return this.props;
    }
}

