/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.core.api.impl;

import org.apache.commons.lang3.StringUtils;
import org.apache.shardingsphere.data.pipeline.api.job.JobType;
import org.apache.shardingsphere.data.pipeline.core.api.PipelineAPIFactory;
import org.apache.shardingsphere.data.pipeline.core.api.PipelineMetaDataPersistService;
import org.apache.shardingsphere.infra.config.rule.data.pipeline.PipelineProcessConfiguration;
import org.apache.shardingsphere.infra.util.yaml.YamlEngine;
import org.apache.shardingsphere.infra.yaml.config.pojo.data.pipeline.YamlPipelineProcessConfiguration;
import org.apache.shardingsphere.infra.yaml.config.swapper.rule.data.pipeline.YamlPipelineProcessConfigurationSwapper;

public final class PipelineProcessConfigurationPersistService
implements PipelineMetaDataPersistService<PipelineProcessConfiguration> {
    private static final YamlPipelineProcessConfigurationSwapper PROCESS_CONFIG_SWAPPER = new YamlPipelineProcessConfigurationSwapper();

    @Override
    public PipelineProcessConfiguration load(JobType jobType) {
        String yamlText = PipelineAPIFactory.getGovernanceRepositoryAPI().getMetaDataProcessConfiguration(jobType);
        if (StringUtils.isBlank((CharSequence)yamlText)) {
            return null;
        }
        return PROCESS_CONFIG_SWAPPER.swapToObject((YamlPipelineProcessConfiguration)YamlEngine.unmarshal((String)yamlText, YamlPipelineProcessConfiguration.class, (boolean)true));
    }

    @Override
    public void persist(JobType jobType, PipelineProcessConfiguration processConfig) {
        String yamlText = YamlEngine.marshal((Object)PROCESS_CONFIG_SWAPPER.swapToYamlConfiguration(processConfig));
        PipelineAPIFactory.getGovernanceRepositoryAPI().persistMetaDataProcessConfiguration(jobType, yamlText);
    }
}

