/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.core.api.impl;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.shardingsphere.data.pipeline.api.job.JobType;
import org.apache.shardingsphere.data.pipeline.core.api.PipelineAPIFactory;
import org.apache.shardingsphere.data.pipeline.core.api.PipelineMetaDataPersistService;
import org.apache.shardingsphere.infra.datasource.props.DataSourceProperties;
import org.apache.shardingsphere.infra.util.yaml.YamlEngine;
import org.apache.shardingsphere.infra.yaml.config.swapper.resource.YamlDataSourceConfigurationSwapper;

public final class PipelineDataSourcePersistService
implements PipelineMetaDataPersistService<Map<String, DataSourceProperties>> {
    private static final YamlDataSourceConfigurationSwapper DATA_SOURCE_CONFIG_SWAPPER = new YamlDataSourceConfigurationSwapper();

    @Override
    public Map<String, DataSourceProperties> load(JobType jobType) {
        String dataSourcesProperties = PipelineAPIFactory.getGovernanceRepositoryAPI().getMetaDataDataSources(jobType);
        if (StringUtils.isBlank((CharSequence)dataSourcesProperties)) {
            return Collections.emptyMap();
        }
        Map yamlDataSources = (Map)YamlEngine.unmarshal((String)dataSourcesProperties, Map.class);
        LinkedHashMap<String, DataSourceProperties> result = new LinkedHashMap<String, DataSourceProperties>(yamlDataSources.size());
        yamlDataSources.forEach((key, value) -> result.put((String)key, DATA_SOURCE_CONFIG_SWAPPER.swapToDataSourceProperties(value)));
        return result;
    }

    @Override
    public void persist(JobType jobType, Map<String, DataSourceProperties> dataSourcePropsMap) {
        LinkedHashMap<String, Map> dataSourceMap = new LinkedHashMap<String, Map>(dataSourcePropsMap.size());
        for (Map.Entry<String, DataSourceProperties> entry : dataSourcePropsMap.entrySet()) {
            dataSourceMap.put(entry.getKey(), DATA_SOURCE_CONFIG_SWAPPER.swapToMap(entry.getValue()));
        }
        PipelineAPIFactory.getGovernanceRepositoryAPI().persistMetaDataDataSources(jobType, YamlEngine.marshal(dataSourceMap));
    }
}

