/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.core.api.impl;

import com.google.common.base.Strings;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.data.pipeline.api.job.JobType;
import org.apache.shardingsphere.data.pipeline.core.api.GovernanceRepositoryAPI;
import org.apache.shardingsphere.data.pipeline.core.metadata.node.PipelineMetaDataNode;
import org.apache.shardingsphere.mode.repository.cluster.ClusterPersistRepository;
import org.apache.shardingsphere.mode.repository.cluster.listener.DataChangedEventListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class GovernanceRepositoryAPIImpl
implements GovernanceRepositoryAPI {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GovernanceRepositoryAPIImpl.class);
    private final ClusterPersistRepository repository;

    @Override
    public boolean isExisted(String key) {
        return null != this.repository.get(key);
    }

    @Override
    public void persistJobItemProgress(String jobId, int shardingItem, String progressValue) {
        this.repository.persist(PipelineMetaDataNode.getJobOffsetItemPath(jobId, shardingItem), progressValue);
    }

    @Override
    public String getJobItemProgress(String jobId, int shardingItem) {
        return this.repository.get(PipelineMetaDataNode.getJobOffsetItemPath(jobId, shardingItem));
    }

    @Override
    public void persistJobCheckResult(String jobId, boolean checkSuccess) {
        log.info("persist job check result '{}' for job {}", (Object)checkSuccess, (Object)jobId);
        this.repository.persist(PipelineMetaDataNode.getJobCheckResultPath(jobId), String.valueOf(checkSuccess));
    }

    @Override
    public Optional<Boolean> getJobCheckResult(String jobId) {
        String data = this.repository.get(PipelineMetaDataNode.getJobCheckResultPath(jobId));
        return Strings.isNullOrEmpty((String)data) ? Optional.empty() : Optional.of(Boolean.parseBoolean(data));
    }

    @Override
    public void deleteJob(String jobId) {
        log.info("delete job {}", (Object)jobId);
        this.repository.delete(PipelineMetaDataNode.getJobRootPath(jobId));
    }

    @Override
    public List<String> getChildrenKeys(String key) {
        return this.repository.getChildrenKeys(key);
    }

    @Override
    public void watch(String key, DataChangedEventListener listener) {
        this.repository.watch(key, listener);
    }

    @Override
    public void persist(String key, String value) {
        this.repository.persist(key, value);
    }

    @Override
    public List<Integer> getShardingItems(String jobId) {
        List<String> result = this.getChildrenKeys(PipelineMetaDataNode.getJobOffsetPath(jobId));
        log.info("getShardingItems, jobId={}, offsetKeys={}", (Object)jobId, result);
        return result.stream().map(Integer::parseInt).collect(Collectors.toList());
    }

    @Override
    public String getMetaDataDataSources(JobType jobType) {
        return this.repository.get(PipelineMetaDataNode.getMetaDataDataSourcesPath(jobType));
    }

    @Override
    public void persistMetaDataDataSources(JobType jobType, String metaDataDataSources) {
        this.repository.persist(PipelineMetaDataNode.getMetaDataDataSourcesPath(jobType), metaDataDataSources);
    }

    @Override
    public String getMetaDataProcessConfiguration(JobType jobType) {
        return this.repository.get(PipelineMetaDataNode.getMetaDataProcessConfigPath(jobType));
    }

    @Override
    public void persistMetaDataProcessConfiguration(JobType jobType, String processConfigYamlText) {
        this.repository.persist(PipelineMetaDataNode.getMetaDataProcessConfigPath(jobType), processConfigYamlText);
    }

    @Generated
    public GovernanceRepositoryAPIImpl(ClusterPersistRepository repository) {
        this.repository = repository;
    }
}

