/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.core.api.impl;

import com.google.common.base.Preconditions;
import java.sql.SQLException;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.apache.shardingsphere.data.pipeline.api.config.job.PipelineJobConfiguration;
import org.apache.shardingsphere.data.pipeline.api.config.job.yaml.YamlPipelineJobConfiguration;
import org.apache.shardingsphere.data.pipeline.api.job.JobType;
import org.apache.shardingsphere.data.pipeline.api.job.PipelineJobId;
import org.apache.shardingsphere.data.pipeline.api.pojo.PipelineJobInfo;
import org.apache.shardingsphere.data.pipeline.core.api.GovernanceRepositoryAPI;
import org.apache.shardingsphere.data.pipeline.core.api.PipelineAPIFactory;
import org.apache.shardingsphere.data.pipeline.core.api.PipelineJobAPI;
import org.apache.shardingsphere.data.pipeline.core.api.impl.PipelineProcessConfigurationPersistService;
import org.apache.shardingsphere.data.pipeline.core.context.PipelineContext;
import org.apache.shardingsphere.data.pipeline.core.exception.PipelineJobCreationException;
import org.apache.shardingsphere.data.pipeline.core.exception.PipelineJobNotFoundException;
import org.apache.shardingsphere.data.pipeline.core.exception.PipelineMetaDataException;
import org.apache.shardingsphere.data.pipeline.core.exception.PipelineVerifyFailedException;
import org.apache.shardingsphere.data.pipeline.core.job.PipelineJobIdUtils;
import org.apache.shardingsphere.data.pipeline.core.metadata.node.PipelineMetaDataNode;
import org.apache.shardingsphere.data.pipeline.core.util.PipelineDistributedBarrier;
import org.apache.shardingsphere.data.pipeline.core.util.PipelineProcessConfigurationUtils;
import org.apache.shardingsphere.data.pipeline.scenario.migration.MigrationJob;
import org.apache.shardingsphere.elasticjob.infra.pojo.JobConfigurationPOJO;
import org.apache.shardingsphere.elasticjob.lite.lifecycle.domain.JobBriefInfo;
import org.apache.shardingsphere.infra.config.mode.ModeConfiguration;
import org.apache.shardingsphere.infra.config.rule.data.pipeline.PipelineProcessConfiguration;
import org.apache.shardingsphere.infra.util.yaml.YamlEngine;
import org.apache.shardingsphere.infra.yaml.config.pojo.data.pipeline.YamlPipelineProcessConfiguration;
import org.apache.shardingsphere.infra.yaml.config.swapper.rule.data.pipeline.YamlPipelineProcessConfigurationSwapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractPipelineJobAPIImpl
implements PipelineJobAPI {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractPipelineJobAPIImpl.class);
    protected static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
    private static final YamlPipelineProcessConfigurationSwapper PROCESS_CONFIG_SWAPPER = new YamlPipelineProcessConfigurationSwapper();
    private final PipelineProcessConfigurationPersistService processConfigPersistService = new PipelineProcessConfigurationPersistService();
    private final PipelineDistributedBarrier pipelineDistributedBarrier = PipelineDistributedBarrier.getInstance();

    protected abstract JobType getJobType();

    public void createProcessConfiguration(PipelineProcessConfiguration processConfig) {
        PipelineProcessConfiguration existingProcessConfig = this.processConfigPersistService.load(this.getJobType());
        if (null != existingProcessConfig) {
            throw new PipelineMetaDataException("Process configuration already exists");
        }
        this.processConfigPersistService.persist(this.getJobType(), processConfig);
    }

    public void alterProcessConfiguration(PipelineProcessConfiguration processConfig) {
        YamlPipelineProcessConfiguration targetYamlProcessConfig = this.getTargetYamlProcessConfiguration();
        targetYamlProcessConfig.copyNonNullFields(PROCESS_CONFIG_SWAPPER.swapToYamlConfiguration(processConfig));
        this.processConfigPersistService.persist(this.getJobType(), PROCESS_CONFIG_SWAPPER.swapToObject(targetYamlProcessConfig));
    }

    private YamlPipelineProcessConfiguration getTargetYamlProcessConfiguration() {
        PipelineProcessConfiguration existingProcessConfig = this.processConfigPersistService.load(this.getJobType());
        if (null == existingProcessConfig) {
            throw new PipelineMetaDataException("Process configuration does not exist");
        }
        return PROCESS_CONFIG_SWAPPER.swapToYamlConfiguration(existingProcessConfig);
    }

    public void dropProcessConfiguration(String confPath) {
        String finalConfPath = confPath.trim();
        PipelineProcessConfigurationUtils.verifyConfPath(confPath);
        YamlPipelineProcessConfiguration targetYamlProcessConfig = this.getTargetYamlProcessConfiguration();
        PipelineProcessConfigurationUtils.setFieldsNullByConfPath(targetYamlProcessConfig, finalConfPath);
        this.processConfigPersistService.persist(this.getJobType(), PROCESS_CONFIG_SWAPPER.swapToObject(targetYamlProcessConfig));
    }

    public PipelineProcessConfiguration showProcessConfiguration() {
        PipelineProcessConfiguration result = this.processConfigPersistService.load(this.getJobType());
        result = PipelineProcessConfigurationUtils.convertWithDefaultValue(result);
        return result;
    }

    @Override
    public final String marshalJobId(PipelineJobId pipelineJobId) {
        return PipelineJobIdUtils.marshalJobIdCommonPrefix(pipelineJobId) + this.marshalJobIdLeftPart(pipelineJobId);
    }

    protected abstract String marshalJobIdLeftPart(PipelineJobId var1);

    public List<? extends PipelineJobInfo> list() {
        this.checkModeConfig();
        return this.getJobBriefInfos().map(each -> this.getJobInfo(each.getJobName())).collect(Collectors.toList());
    }

    protected void checkModeConfig() {
        ModeConfiguration modeConfig = PipelineContext.getModeConfig();
        Preconditions.checkNotNull((Object)modeConfig, (Object)"Mode configuration is required.");
        Preconditions.checkArgument((boolean)"Cluster".equalsIgnoreCase(modeConfig.getType()), (Object)"Mode must be `Cluster`.");
    }

    private Stream<JobBriefInfo> getJobBriefInfos() {
        return PipelineAPIFactory.getJobStatisticsAPI().getAllJobsBriefInfo().stream().filter(each -> !each.getJobName().startsWith("_")).filter(each -> PipelineJobIdUtils.parseJobType(each.getJobName()) == this.getJobType());
    }

    protected abstract PipelineJobInfo getJobInfo(String var1);

    protected void fillJobInfo(PipelineJobInfo jobInfo, JobConfigurationPOJO jobConfigPOJO) {
        jobInfo.setActive(!jobConfigPOJO.isDisabled());
        jobInfo.setShardingTotalCount(jobConfigPOJO.getShardingTotalCount());
        jobInfo.setCreateTime(jobConfigPOJO.getProps().getProperty("create_time"));
        jobInfo.setStopTime(jobConfigPOJO.getProps().getProperty("stop_time"));
    }

    @Override
    public Optional<String> start(PipelineJobConfiguration jobConfig) {
        String jobId = jobConfig.getJobId();
        if (0 == jobConfig.getJobShardingCount()) {
            log.warn("Invalid job config since job sharding count is 0, jobId={}", (Object)jobId);
            throw new PipelineJobCreationException("job sharding count is 0, jobId: " + jobId);
        }
        log.info("Start job by {}", (Object)jobConfig);
        GovernanceRepositoryAPI repositoryAPI = PipelineAPIFactory.getGovernanceRepositoryAPI();
        String jobConfigKey = PipelineMetaDataNode.getJobConfigPath(jobId);
        if (repositoryAPI.isExisted(jobConfigKey)) {
            log.warn("jobId already exists in registry center, ignore, jobConfigKey={}", (Object)jobConfigKey);
            return Optional.of(jobId);
        }
        repositoryAPI.persist(PipelineMetaDataNode.getJobRootPath(jobId), MigrationJob.class.getName());
        repositoryAPI.persist(jobConfigKey, this.convertJobConfigurationToText(jobConfig));
        return Optional.of(jobId);
    }

    private String convertJobConfigurationToText(PipelineJobConfiguration jobConfig) {
        JobConfigurationPOJO jobConfigPOJO = new JobConfigurationPOJO();
        jobConfigPOJO.setJobName(jobConfig.getJobId());
        jobConfigPOJO.setShardingTotalCount(jobConfig.getJobShardingCount());
        jobConfigPOJO.setJobParameter(YamlEngine.marshal((Object)this.swapToYamlJobConfiguration(jobConfig)));
        jobConfigPOJO.getProps().setProperty("create_time", LocalDateTime.now().format(DATE_TIME_FORMATTER));
        return YamlEngine.marshal((Object)jobConfigPOJO);
    }

    protected abstract YamlPipelineJobConfiguration swapToYamlJobConfiguration(PipelineJobConfiguration var1);

    protected abstract PipelineJobConfiguration getJobConfiguration(JobConfigurationPOJO var1);

    public void startDisabledJob(String jobId) {
        log.info("Start disabled pipeline job {}", (Object)jobId);
        this.pipelineDistributedBarrier.removeParentNode(PipelineMetaDataNode.getJobBarrierDisablePath(jobId));
        JobConfigurationPOJO jobConfigPOJO = this.getElasticJobConfigPOJO(jobId);
        if (!jobConfigPOJO.isDisabled()) {
            throw new PipelineVerifyFailedException("Job is already started.");
        }
        jobConfigPOJO.setDisabled(false);
        jobConfigPOJO.getProps().remove("stop_time");
        PipelineAPIFactory.getJobConfigurationAPI().updateJobConfiguration(jobConfigPOJO);
        String barrierPath = PipelineMetaDataNode.getJobBarrierEnablePath(jobId);
        this.pipelineDistributedBarrier.register(barrierPath, jobConfigPOJO.getShardingTotalCount());
        this.pipelineDistributedBarrier.await(barrierPath, 5L, TimeUnit.SECONDS);
    }

    public void stop(String jobId) {
        log.info("Stop pipeline job {}", (Object)jobId);
        this.pipelineDistributedBarrier.removeParentNode(PipelineMetaDataNode.getJobBarrierEnablePath(jobId));
        JobConfigurationPOJO jobConfigPOJO = this.getElasticJobConfigPOJO(jobId);
        jobConfigPOJO.setDisabled(true);
        jobConfigPOJO.getProps().setProperty("stop_time", LocalDateTime.now().format(DATE_TIME_FORMATTER));
        PipelineAPIFactory.getJobConfigurationAPI().updateJobConfiguration(jobConfigPOJO);
        String barrierPath = PipelineMetaDataNode.getJobBarrierDisablePath(jobId);
        this.pipelineDistributedBarrier.register(barrierPath, jobConfigPOJO.getShardingTotalCount());
        this.pipelineDistributedBarrier.await(barrierPath, 5L, TimeUnit.SECONDS);
    }

    public void rollback(String jobId) throws SQLException {
        log.info("Rollback job {}", (Object)jobId);
        this.stop(jobId);
        this.cleanTempTableOnRollback(jobId);
        this.dropJob(jobId);
    }

    protected abstract void cleanTempTableOnRollback(String var1) throws SQLException;

    private void dropJob(String jobId) {
        PipelineAPIFactory.getJobOperateAPI().remove(String.valueOf(jobId), null);
        PipelineAPIFactory.getGovernanceRepositoryAPI().deleteJob(jobId);
    }

    public void commit(String jobId) {
        this.checkModeConfig();
        log.info("Commit job {}", (Object)jobId);
        this.stop(jobId);
        this.dropJob(jobId);
    }

    protected final JobConfigurationPOJO getElasticJobConfigPOJO(String jobId) {
        JobConfigurationPOJO result = PipelineAPIFactory.getJobConfigurationAPI().getJobConfiguration(jobId);
        if (null == result) {
            throw new PipelineJobNotFoundException(jobId);
        }
        return result;
    }

    public String getType() {
        return this.getJobType().getTypeName();
    }
}

