/*
 * Decompiled with CFR 0.152.
 */
package io.seata.rm.datasource.undo;

import io.seata.common.exception.ShouldNeverHappenException;
import io.seata.rm.datasource.undo.AbstractUndoExecutor;
import io.seata.rm.datasource.undo.SQLUndoLog;
import io.seata.rm.datasource.undo.UndoExecutorHolder;
import io.seata.rm.datasource.undo.UndoExecutorHolderFactory;

public class UndoExecutorFactory {
    public static AbstractUndoExecutor getUndoExecutor(String dbType, SQLUndoLog sqlUndoLog) {
        AbstractUndoExecutor result = null;
        UndoExecutorHolder holder = UndoExecutorHolderFactory.getUndoExecutorHolder(dbType.toLowerCase());
        switch (sqlUndoLog.getSqlType()) {
            case INSERT: {
                result = holder.getInsertExecutor(sqlUndoLog);
                break;
            }
            case UPDATE: {
                result = holder.getUpdateExecutor(sqlUndoLog);
                break;
            }
            case DELETE: {
                result = holder.getDeleteExecutor(sqlUndoLog);
                break;
            }
            default: {
                throw new ShouldNeverHappenException();
            }
        }
        return result;
    }
}

