/*
 * Decompiled with CFR 0.152.
 */
package io.seata.rm.datasource.sql.struct;

import io.seata.common.exception.NotSupportYetException;
import io.seata.common.util.CollectionUtils;
import io.seata.rm.datasource.ColumnUtils;
import io.seata.rm.datasource.sql.struct.ColumnMeta;
import io.seata.rm.datasource.sql.struct.IndexMeta;
import io.seata.rm.datasource.sql.struct.IndexType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class TableMeta {
    private String tableName;
    private Map<String, ColumnMeta> allColumns = new LinkedHashMap<String, ColumnMeta>();
    private Map<String, IndexMeta> allIndexes = new LinkedHashMap<String, IndexMeta>();

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public ColumnMeta getColumnMeta(String colName) {
        return this.allColumns.get(colName);
    }

    public Map<String, ColumnMeta> getAllColumns() {
        return this.allColumns;
    }

    public Map<String, IndexMeta> getAllIndexes() {
        return this.allIndexes;
    }

    public ColumnMeta getAutoIncreaseColumn() {
        for (Map.Entry<String, ColumnMeta> entry : this.allColumns.entrySet()) {
            ColumnMeta col = entry.getValue();
            if (!"YES".equalsIgnoreCase(col.getIsAutoincrement())) continue;
            return col;
        }
        return null;
    }

    public Map<String, ColumnMeta> getPrimaryKeyMap() {
        HashMap<String, ColumnMeta> pk = new HashMap<String, ColumnMeta>();
        for (Map.Entry<String, IndexMeta> entry : this.allIndexes.entrySet()) {
            IndexMeta index = entry.getValue();
            if (index.getIndextype().value() != IndexType.PRIMARY.value()) continue;
            for (ColumnMeta col : index.getValues()) {
                pk.put(col.getColumnName(), col);
            }
        }
        if (pk.size() < 1) {
            throw new NotSupportYetException(String.format("%s needs to contain the primary key.", this.tableName));
        }
        return pk;
    }

    public List<String> getPrimaryKeyOnlyName() {
        ArrayList<String> list = new ArrayList<String>();
        for (Map.Entry<String, ColumnMeta> entry : this.getPrimaryKeyMap().entrySet()) {
            list.add(entry.getKey());
        }
        return list;
    }

    public List<String> getEscapePkNameList(String dbType) {
        return ColumnUtils.addEscape(this.getPrimaryKeyOnlyName(), dbType);
    }

    public boolean containsPK(List<String> cols) {
        if (cols == null) {
            return false;
        }
        List<String> pk = this.getPrimaryKeyOnlyName();
        if (pk.isEmpty()) {
            return false;
        }
        if (cols.containsAll(pk)) {
            return true;
        }
        return CollectionUtils.toUpperList(cols).containsAll(CollectionUtils.toUpperList(pk));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TableMeta)) {
            return false;
        }
        TableMeta tableMeta = (TableMeta)o;
        if (!Objects.equals(tableMeta.tableName, this.tableName)) {
            return false;
        }
        if (!Objects.equals(tableMeta.allColumns, this.allColumns)) {
            return false;
        }
        return Objects.equals(tableMeta.allIndexes, this.allIndexes);
    }

    public int hashCode() {
        int hash = Objects.hashCode(this.tableName);
        hash += Objects.hashCode(this.allColumns);
        return hash += Objects.hashCode(this.allIndexes);
    }
}

