/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.enricher.fabric8;

import io.fabric8.kubernetes.api.model.Probe;
import io.fabric8.kubernetes.api.model.ProbeBuilder;
import io.fabric8.kubernetes.api.model.ProbeFluent;
import io.fabric8.maven.core.util.Configs;
import io.fabric8.maven.enricher.api.EnricherContext;
import io.fabric8.maven.enricher.api.MavenEnricherContext;
import io.fabric8.maven.enricher.fabric8.AbstractHealthCheckEnricher;
import org.apache.commons.lang3.StringUtils;

public class WebAppHealthCheckEnricher
extends AbstractHealthCheckEnricher {
    public WebAppHealthCheckEnricher(MavenEnricherContext buildContext) {
        super((EnricherContext)buildContext, "f8-healthcheck-webapp");
    }

    @Override
    protected Probe getLivenessProbe() {
        return this.getProbe(false);
    }

    @Override
    protected Probe getReadinessProbe() {
        return this.getProbe(true);
    }

    private boolean isApplicable() {
        return this.getContext().hasPlugin("org.apache.maven.plugins", "maven-war-plugin") && StringUtils.isNotEmpty((CharSequence)Configs.asString((String)this.getConfig(Config.path)));
    }

    private Probe getProbe(boolean readiness) {
        if (!this.isApplicable()) {
            return null;
        }
        Integer port = this.getPort();
        String scheme = this.getScheme().toUpperCase();
        String path = this.getPath();
        int delay = readiness ? this.getInitialReadinessDelay() : this.getInitialLivenessDelay();
        return ((ProbeBuilder)((ProbeBuilder)((ProbeFluent.HttpGetNested)((ProbeFluent.HttpGetNested)((ProbeFluent.HttpGetNested)new ProbeBuilder().withNewHttpGet().withNewPort(port)).withPath(path)).withScheme(scheme)).endHttpGet()).withInitialDelaySeconds(Integer.valueOf(delay))).build();
    }

    private int getInitialReadinessDelay() {
        return Configs.asInt((String)this.getConfig(Config.initialReadinessDelay));
    }

    private int getInitialLivenessDelay() {
        return Configs.asInt((String)this.getConfig(Config.initialLivenessDelay));
    }

    protected String getScheme() {
        return Configs.asString((String)this.getConfig(Config.scheme));
    }

    protected int getPort() {
        return Configs.asInt((String)this.getConfig(Config.port));
    }

    protected String getPath() {
        return Configs.asString((String)this.getConfig(Config.path));
    }

    private static enum Config implements Configs.Key
    {
        scheme{
            {
                this.d = "HTTP";
            }
        }
        ,
        port{
            {
                this.d = "8080";
            }
        }
        ,
        path{
            {
                this.d = "";
            }
        }
        ,
        initialReadinessDelay{
            {
                this.d = "10";
            }
        }
        ,
        initialLivenessDelay{
            {
                this.d = "180";
            }
        };

        protected String d;

        public String def() {
            return this.d;
        }
    }
}

