/*
 * Decompiled with CFR 0.152.
 */
package com.rnkrsoft.bopomofo4j.sandbox.v100;

import com.rnkrsoft.bopomofo4j.protocol.IBopomofoKernel;
import com.rnkrsoft.bopomofo4j.sandbox.v100.HttpRequest;
import com.rnkrsoft.bopomofo4j.sandbox.v100.LocalKernel;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Iterator;
import java.util.ServiceLoader;
import java.util.UUID;

public class SandboxBopomofoKernel
implements IBopomofoKernel {
    static final String GROUP_ID = "com.rnkrsoft.bopomofo4j";
    static final String ARTIFACT_ID = "bopomofo4j";
    static final String MAVEN_CENTER = "https://repo1.maven.org/maven2";
    IBopomofoKernel proxy;
    final IBopomofoKernel local = new LocalKernel();
    URLClassLoader sandboxClassLoader;
    Class<? extends IBopomofoKernel> kernelClass;
    boolean sandboxMode = true;
    long lastCheckMs = -1L;

    public void sandbox() {
        this.sandboxMode = true;
    }

    public void local() {
        this.sandboxMode = false;
    }

    void check() {
        block9: {
            if (this.sandboxMode) {
                if (System.currentTimeMillis() - this.lastCheckMs > 60000L && (this.proxy == null || this.proxy == this.local)) {
                    String tempDir = System.getProperty("bopomofo4j.temp.dir", "./bopomofo4j-temp");
                    String jarUrl = System.getProperty("bopomofo4j.sandbox.url");
                    try {
                        if (jarUrl == null || jarUrl.isEmpty()) {
                            jarUrl = this.fetchLastReleaseVersionUrl(MAVEN_CENTER, GROUP_ID, ARTIFACT_ID);
                        }
                        File file = this.download(jarUrl, tempDir);
                        URL url = file.toURI().toURL();
                        this.sandboxClassLoader = new URLClassLoader(new URL[]{url}, Thread.currentThread().getContextClassLoader());
                        this.kernelClass = this.sandboxClassLoader.loadClass(LocalKernel.class.getName());
                        ServiceLoader<IBopomofoKernel> serviceLoader = ServiceLoader.load(IBopomofoKernel.class, this.sandboxClassLoader);
                        Iterator<IBopomofoKernel> iterator = serviceLoader.iterator();
                        IBopomofoKernel lastNewKernel = this.local;
                        while (iterator.hasNext()) {
                            IBopomofoKernel instance = iterator.next();
                            if (instance.version() <= this.local.version()) continue;
                            lastNewKernel = instance;
                        }
                        if (lastNewKernel != this.local) {
                            this.proxy = lastNewKernel;
                            System.out.println("Bopomofo4j Sandbox load success! sandbox version:" + this.proxy.version());
                            break block9;
                        }
                        this.lastCheckMs = System.currentTimeMillis();
                        this.proxy = this.local;
                        System.err.println("Bopomofo4j local is last new version! use local version:" + this.proxy.version());
                    }
                    catch (Exception e) {
                        this.lastCheckMs = System.currentTimeMillis();
                        this.proxy = this.local;
                        System.err.println("Bopomofo4j Sandbox load happens error! use local version:" + this.proxy.version());
                    }
                }
            } else if (this.proxy == null || this.proxy != this.local) {
                this.proxy = this.local;
            }
        }
    }

    @Override
    public String pinyin(String words, Integer toneType, Boolean upper, Boolean cap, String split) {
        this.check();
        return this.proxy.pinyin(words, toneType, upper, cap, split);
    }

    @Override
    public String cht2chs(String words) {
        this.check();
        return this.proxy.cht2chs(words);
    }

    @Override
    public String chs2cht(String words) {
        this.check();
        return this.proxy.chs2cht(words);
    }

    @Override
    public int version() {
        this.check();
        return this.proxy.version();
    }

    File download(String url, String tempDir) throws IOException {
        HttpRequest http = HttpRequest.get(url).connectTimeout(20000).readTimeout(15000).useCaches(false).contentType("application/octet-stream", "UTF-8");
        File jarFile = new File(tempDir, "bopomofo4j-" + UUID.randomUUID().toString() + ".jar");
        if (!jarFile.getParentFile().exists()) {
            jarFile.getParentFile().mkdirs();
        }
        http.receive(jarFile);
        if (!http.ok()) {
            throw new IOException("\u4e0b\u8f7d\u6587\u4ef6\u5931\u8d25");
        }
        return jarFile;
    }

    String fetchLastReleaseVersionUrl(String mavenCenter, String groupId, String artifactId) {
        String metadataUrl = (mavenCenter = mavenCenter == null ? MAVEN_CENTER : mavenCenter) + "/" + groupId.replaceAll("\\.", "/") + "/" + artifactId + "/maven-metadata.xml";
        HttpRequest http = HttpRequest.get(metadataUrl).connectTimeout(10000).readTimeout(8000).useCaches(false).contentType("application/octet-stream", "UTF-8");
        if (http.ok()) {
            String xml = http.body();
            if (xml == null || xml.isEmpty()) {
                return null;
            }
            int beginIndex = xml.indexOf("<versioning>");
            int endIndex = xml.indexOf("</versioning>", beginIndex);
            String temp = xml.substring(beginIndex + "<versioning>".length(), endIndex);
            int tsBeginIdx = temp.indexOf("<latest>");
            int tsEndIdx = temp.indexOf("</latest>");
            String latest = temp.substring(tsBeginIdx + "<latest>".length(), tsEndIdx);
            return mavenCenter + "/" + groupId.replaceAll("\\.", "/") + "/" + artifactId + "/" + latest + "/" + artifactId + "-" + latest + ".jar";
        }
        throw new RuntimeException("[" + groupId + ":" + artifactId + "] is not found!");
    }
}

