/*
 * Decompiled with CFR 0.152.
 */
package com.rnkrsoft.bopomofo4j.sandbox.v100;

import com.rnkrsoft.bopomofo4j.protocol.IPinyinLibrary;
import com.rnkrsoft.bopomofo4j.sandbox.v100.JSON;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Map;

public class LocalPinyinLibrary
implements IPinyinLibrary {
    static final String PINYIN_SEPARATOR = ",";
    static final LocalPinyinLibrary library = new LocalPinyinLibrary().init();
    static final String PINYINS_FILE_NAME = "META-INF/resources/bopomofo/libs/v100/pinyins.json";
    static final String POLYPHONES_FILE_NAME = "META-INF/resources/bopomofo/libs/v100/polyphones.json";
    static final String CHT2CHS_FILE_NAME = "META-INF/resources/bopomofo/libs/v100/cht2chs.json";
    static final String CHS2CHT_FILE_NAME = "META-INF/resources/bopomofo/libs/v100/chs2cht.json";
    Map<String, String> pinyins;
    Map<String, String> polyphones;
    Map<String, String> cht2chs;
    Map<String, String> chs2cht;

    public LocalPinyinLibrary init() {
        URL url = this.getClass().getClassLoader().getResource(PINYINS_FILE_NAME);
        try {
            this.pinyins = JSON.parse(url);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        url = this.getClass().getClassLoader().getResource(POLYPHONES_FILE_NAME);
        try {
            this.polyphones = JSON.parse(url);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        url = this.getClass().getClassLoader().getResource(CHT2CHS_FILE_NAME);
        try {
            this.cht2chs = JSON.parse(url);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        url = this.getClass().getClassLoader().getResource(CHS2CHT_FILE_NAME);
        try {
            this.chs2cht = JSON.parse(url);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return this;
    }

    @Override
    public String[] getPinyins(char w) {
        String py = this.pinyins.get(String.valueOf(w));
        if (py == null) {
            return new String[0];
        }
        return py.split(PINYIN_SEPARATOR);
    }

    @Override
    public IPinyinLibrary.Polyphone getPolyphoneWord(String words, char current, int pos, int lastPolyphoneIndex) {
        ArrayList<IPinyinLibrary.Polyphone> results = new ArrayList<IPinyinLibrary.Polyphone>();
        int maxMatchLen = 0;
        for (String w : this.polyphones.keySet()) {
            int endPos;
            int len = w.length();
            int beginPos = pos - len;
            String temp = words.substring(beginPos = Math.max(lastPolyphoneIndex, beginPos), endPos = Math.min(pos + len, words.length()));
            if (temp.indexOf(w) <= -1) continue;
            if (len > maxMatchLen) {
                maxMatchLen = len;
            }
            int offset = w.indexOf(current);
            IPinyinLibrary.Polyphone data = new IPinyinLibrary.Polyphone(this.polyphones.get(w).split(PINYIN_SEPARATOR), offset, len);
            results.add(data);
        }
        if (results.size() == 1) {
            return (IPinyinLibrary.Polyphone)results.get(0);
        }
        if (results.size() > 1) {
            for (int i = 0; i < results.size(); ++i) {
                IPinyinLibrary.Polyphone value = (IPinyinLibrary.Polyphone)results.get(i);
                if (value.getLength() != maxMatchLen) continue;
                return value;
            }
        }
        return null;
    }

    @Override
    public String chs(char w) {
        String _new = this.cht2chs.get(String.valueOf(w));
        return _new;
    }

    @Override
    public String cht(char w) {
        String _new = this.chs2cht.get(String.valueOf(w));
        return _new;
    }

    public static LocalPinyinLibrary getPinyinLibrary() {
        return library;
    }
}

