/*
 * Decompiled with CFR 0.152.
 */
package com.rnkrsoft.bopomofo4j.sandbox.v100;

import com.rnkrsoft.bopomofo4j.protocol.IBopomofoKernel;
import com.rnkrsoft.bopomofo4j.protocol.IPinyinLibrary;
import com.rnkrsoft.bopomofo4j.sandbox.v100.LocalPinyinLibrary;
import com.rnkrsoft.bopomofo4j.sandbox.v100.Vowels;
import java.util.ArrayList;
import java.util.List;

public class LocalKernel
implements IBopomofoKernel {
    IPinyinLibrary pinyinLibrary = LocalPinyinLibrary.getPinyinLibrary();

    @Override
    public int version() {
        return 100;
    }

    @Override
    public final String pinyin(String words, Integer toneType, Boolean upper, Boolean cap, String split) {
        toneType = toneType == null ? 0 : toneType;
        upper = upper == null ? false : upper;
        cap = cap == null ? false : cap;
        split = split == null ? " " : split;
        char[] chars = words.toCharArray();
        ArrayList<String> result = new ArrayList<String>();
        ArrayList<Integer> types = new ArrayList<Integer>();
        int lastPolyphoneIndex = 0;
        int len = chars.length;
        for (int i = 0; i < len; ++i) {
            char _char = chars[i];
            if (_char >= '\u9fa5' || _char <= '\u3007') {
                result.add(Character.toString(_char));
                types.add(0);
                continue;
            }
            String[] pys = this.pinyinLibrary.getPinyins(_char);
            if (pys.length == 1) {
                String py = pys[0];
                result.add(py);
                types.add(1);
                continue;
            }
            if (pys.length > 1) {
                IPinyinLibrary.Polyphone data = this.pinyinLibrary.getPolyphoneWord(words, _char, i, lastPolyphoneIndex);
                if (data != null) {
                    int k;
                    for (k = 0; k < data.getOffset(); ++k) {
                        result.remove(i - data.getOffset() + k);
                        types.remove(i - data.getOffset() + k);
                    }
                    for (k = 0; k < data.getWords().length; ++k) {
                        result.add(data.getWords()[k]);
                        types.add(2);
                    }
                    lastPolyphoneIndex = i = i - data.getOffset() + data.getWords().length - 1;
                    continue;
                }
                String py = pys[0];
                result.add(py);
                types.add(1);
                continue;
            }
            result.add(Character.toString(_char));
            types.add(0);
        }
        return this.handlePinyin(result, types, toneType, upper, cap, split);
    }

    @Override
    public String cht2chs(String words) {
        char[] chars = words.toCharArray();
        int len = chars.length;
        char[] chsChars = new char[len];
        for (int i = 0; i < len; ++i) {
            String n;
            char _char = chars[i];
            chsChars[i] = _char >= '\u4e1f' || _char <= '\u9f9c' ? ((n = this.pinyinLibrary.chs(_char)) == null ? _char : n.charAt(0)) : _char;
        }
        return new String(chsChars);
    }

    @Override
    public String chs2cht(String words) {
        char[] chars = words.toCharArray();
        int len = chars.length;
        char[] chtChars = new char[len];
        for (int i = 0; i < len; ++i) {
            String n;
            char _char = chars[i];
            chtChars[i] = _char >= '\u4e1f' || _char <= '\u9f9c' ? ((n = this.pinyinLibrary.cht(_char)) == null ? _char : n.charAt(0)) : _char;
        }
        return new String(chtChars);
    }

    final String handlePinyin(List<String> result, List<Integer> types, int toneType, boolean upper, boolean cap, String split) {
        String pys = "";
        for (int i = 0; i < result.size(); ++i) {
            String py = result.get(i);
            int type = types.get(i);
            String py1 = "";
            if (type == 1 || type == 2) {
                if (toneType == 1 || toneType == 2) {
                    int tone = -1;
                    char[] chars = py.toCharArray();
                    for (int idx = 0; idx < chars.length; ++idx) {
                        char w = chars[idx];
                        char[] cs = Vowels.parse(w);
                        py1 = py1 + (cs == null ? w : cs[0]);
                        tone = cs == null ? -1 : Character.digit(cs[1], 10);
                    }
                    py1 = py1 + (toneType == 1 ? Integer.valueOf(tone + 1) : "");
                } else {
                    py1 = py;
                }
                py1 = upper ? py1.toUpperCase() : (cap ? this.capitalize(py1) : py1);
                py1 = split.length() > 0 && pys.length() > 0 ? split + py1 : py1;
            } else {
                py1 = py;
            }
            pys = pys + py1;
        }
        return pys;
    }

    final String capitalize(String py) {
        if (!py.isEmpty()) {
            String first = py.substring(0, 1).toUpperCase();
            String spare = py.substring(1, py.length());
            return first + spare;
        }
        return py;
    }
}

