/*
 * Decompiled with CFR 0.152.
 */
package com.rnkrsoft.bopomofo4j.sandbox.v100;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;

public class JSON {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final Map<String, String> parse(URL url) throws IOException {
        InputStream is = null;
        try {
            is = url.openStream();
            String json = JSON.read(is);
            Map<String, String> map = JSON.parse(json);
            return map;
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                is = null;
            }
        }
    }

    public static final Map<String, String> parse(String json) {
        char[] chars = json.toCharArray();
        HashMap<String, String> map = new HashMap<String, String>();
        int length = chars.length;
        int beginObjectIdx = -1;
        boolean matchKey = false;
        boolean matchValue = false;
        int quotationIdx = -1;
        int matchComma = -1;
        int commaIdx = -1;
        boolean gameOver = false;
        int beginValueIdx = -1;
        boolean firstMatchChar = false;
        boolean matchColon = false;
        String key = null;
        for (int i = 0; i < length; ++i) {
            String value;
            char c = chars[i];
            if (c == ' ' || c == '\n' || c == '\r') {
                if (!matchKey || !matchColon || !firstMatchChar || matchValue) continue;
                value = json.substring(beginValueIdx, i);
                map.put(key, value);
                matchValue = true;
                continue;
            }
            if (c == ':') {
                matchColon = true;
                continue;
            }
            if (gameOver) {
                throw new IllegalArgumentException("illegal json format!");
            }
            if (c == '{') {
                if (beginObjectIdx != -1) continue;
                beginObjectIdx = i;
                continue;
            }
            if (c == '}') {
                if (matchComma == 1) {
                    throw new IllegalArgumentException("illegal json format! cause: index[" + commaIdx + "] = \"" + chars[commaIdx] + "\" is illegal!");
                }
                gameOver = true;
                continue;
            }
            if (c == ',') {
                if (quotationIdx != -1) continue;
                matchKey = false;
                matchValue = false;
                matchColon = false;
                beginValueIdx = -1;
                commaIdx = i;
                matchComma = 1;
                firstMatchChar = false;
                continue;
            }
            if (c == '\"') {
                if (matchComma == -1 || matchComma == 1) {
                    matchComma = 0;
                    commaIdx = -1;
                }
                if (quotationIdx == -1) {
                    quotationIdx = i;
                    continue;
                }
                if (quotationIdx == -1) continue;
                if (!matchKey) {
                    if (quotationIdx > -1) {
                        matchKey = true;
                        key = json.substring(quotationIdx + 1, i);
                    }
                } else if (!matchValue) {
                    value = json.substring(quotationIdx + 1, i);
                    map.put(key, value);
                    matchValue = true;
                } else if (matchKey && matchValue) {
                    throw new IllegalArgumentException("illegal json format! cause: index[" + i + "] = \"" + c + "\" is illegal!");
                }
                quotationIdx = -1;
                continue;
            }
            if (c < '0' && c > '9' && c != '-' && c != '.') continue;
            if (matchKey && matchColon) {
                if (firstMatchChar || beginValueIdx != -1) continue;
                firstMatchChar = true;
                beginValueIdx = i;
                continue;
            }
            if (!matchKey || !matchColon || !firstMatchChar || !matchValue) continue;
            throw new IllegalArgumentException("illegal json format! cause: index[" + i + "] = \"" + c + "\" is illegal!");
        }
        return map;
    }

    static String read(InputStream input) throws IOException {
        int n;
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        byte[] buffer = new byte[4096];
        long count = 0L;
        while (-1 != (n = input.read(buffer))) {
            output.write(buffer, 0, n);
            count += (long)n;
        }
        return new String(output.toByteArray(), "UTF-8");
    }
}

